/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutDataQualityStatisticAnnotationRequest extends GlueRequest implements
        ToCopyableBuilder<BatchPutDataQualityStatisticAnnotationRequest.Builder, BatchPutDataQualityStatisticAnnotationRequest> {
    private static final SdkField<List<DatapointInclusionAnnotation>> INCLUSION_ANNOTATIONS_FIELD = SdkField
            .<List<DatapointInclusionAnnotation>> builder(MarshallingType.LIST)
            .memberName("InclusionAnnotations")
            .getter(getter(BatchPutDataQualityStatisticAnnotationRequest::inclusionAnnotations))
            .setter(setter(Builder::inclusionAnnotations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionAnnotations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatapointInclusionAnnotation> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatapointInclusionAnnotation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(BatchPutDataQualityStatisticAnnotationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUSION_ANNOTATIONS_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DatapointInclusionAnnotation> inclusionAnnotations;

    private final String clientToken;

    private BatchPutDataQualityStatisticAnnotationRequest(BuilderImpl builder) {
        super(builder);
        this.inclusionAnnotations = builder.inclusionAnnotations;
        this.clientToken = builder.clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionAnnotations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInclusionAnnotations() {
        return inclusionAnnotations != null && !(inclusionAnnotations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DatapointInclusionAnnotation</code>'s.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionAnnotations} method.
     * </p>
     * 
     * @return A list of <code>DatapointInclusionAnnotation</code>'s.
     */
    public final List<DatapointInclusionAnnotation> inclusionAnnotations() {
        return inclusionAnnotations;
    }

    /**
     * <p>
     * Client Token.
     * </p>
     * 
     * @return Client Token.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionAnnotations() ? inclusionAnnotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutDataQualityStatisticAnnotationRequest)) {
            return false;
        }
        BatchPutDataQualityStatisticAnnotationRequest other = (BatchPutDataQualityStatisticAnnotationRequest) obj;
        return hasInclusionAnnotations() == other.hasInclusionAnnotations()
                && Objects.equals(inclusionAnnotations(), other.inclusionAnnotations())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutDataQualityStatisticAnnotationRequest")
                .add("InclusionAnnotations", hasInclusionAnnotations() ? inclusionAnnotations() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InclusionAnnotations":
            return Optional.ofNullable(clazz.cast(inclusionAnnotations()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InclusionAnnotations", INCLUSION_ANNOTATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPutDataQualityStatisticAnnotationRequest, T> g) {
        return obj -> g.apply((BatchPutDataQualityStatisticAnnotationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchPutDataQualityStatisticAnnotationRequest> {
        /**
         * <p>
         * A list of <code>DatapointInclusionAnnotation</code>'s.
         * </p>
         * 
         * @param inclusionAnnotations
         *        A list of <code>DatapointInclusionAnnotation</code>'s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionAnnotations(Collection<DatapointInclusionAnnotation> inclusionAnnotations);

        /**
         * <p>
         * A list of <code>DatapointInclusionAnnotation</code>'s.
         * </p>
         * 
         * @param inclusionAnnotations
         *        A list of <code>DatapointInclusionAnnotation</code>'s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionAnnotations(DatapointInclusionAnnotation... inclusionAnnotations);

        /**
         * <p>
         * A list of <code>DatapointInclusionAnnotation</code>'s.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.DatapointInclusionAnnotation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.glue.model.DatapointInclusionAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.DatapointInclusionAnnotation.Builder#build()} is called
         * immediately and its result is passed to {@link #inclusionAnnotations(List<DatapointInclusionAnnotation>)}.
         * 
         * @param inclusionAnnotations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.DatapointInclusionAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inclusionAnnotations(java.util.Collection<DatapointInclusionAnnotation>)
         */
        Builder inclusionAnnotations(Consumer<DatapointInclusionAnnotation.Builder>... inclusionAnnotations);

        /**
         * <p>
         * Client Token.
         * </p>
         * 
         * @param clientToken
         *        Client Token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private List<DatapointInclusionAnnotation> inclusionAnnotations = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutDataQualityStatisticAnnotationRequest model) {
            super(model);
            inclusionAnnotations(model.inclusionAnnotations);
            clientToken(model.clientToken);
        }

        public final List<DatapointInclusionAnnotation.Builder> getInclusionAnnotations() {
            List<DatapointInclusionAnnotation.Builder> result = InclusionAnnotationListCopier
                    .copyToBuilder(this.inclusionAnnotations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInclusionAnnotations(Collection<DatapointInclusionAnnotation.BuilderImpl> inclusionAnnotations) {
            this.inclusionAnnotations = InclusionAnnotationListCopier.copyFromBuilder(inclusionAnnotations);
        }

        @Override
        public final Builder inclusionAnnotations(Collection<DatapointInclusionAnnotation> inclusionAnnotations) {
            this.inclusionAnnotations = InclusionAnnotationListCopier.copy(inclusionAnnotations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionAnnotations(DatapointInclusionAnnotation... inclusionAnnotations) {
            inclusionAnnotations(Arrays.asList(inclusionAnnotations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionAnnotations(Consumer<DatapointInclusionAnnotation.Builder>... inclusionAnnotations) {
            inclusionAnnotations(Stream.of(inclusionAnnotations)
                    .map(c -> DatapointInclusionAnnotation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutDataQualityStatisticAnnotationRequest build() {
            return new BatchPutDataQualityStatisticAnnotationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
