/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkflowRequest extends GlueRequest implements
        ToCopyableBuilder<CreateWorkflowRequest.Builder, CreateWorkflowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateWorkflowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateWorkflowRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> DEFAULT_RUN_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DefaultRunProperties")
            .getter(getter(CreateWorkflowRequest::defaultRunProperties))
            .setter(setter(Builder::defaultRunProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRunProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateWorkflowRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_CONCURRENT_RUNS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrentRuns").getter(getter(CreateWorkflowRequest::maxConcurrentRuns))
            .setter(setter(Builder::maxConcurrentRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentRuns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            DEFAULT_RUN_PROPERTIES_FIELD, TAGS_FIELD, MAX_CONCURRENT_RUNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final Map<String, String> defaultRunProperties;

    private final Map<String, String> tags;

    private final Integer maxConcurrentRuns;

    private CreateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.defaultRunProperties = builder.defaultRunProperties;
        this.tags = builder.tags;
        this.maxConcurrentRuns = builder.maxConcurrentRuns;
    }

    /**
     * <p>
     * The name to be assigned to the workflow. It should be unique within your account.
     * </p>
     * 
     * @return The name to be assigned to the workflow. It should be unique within your account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the workflow.
     * </p>
     * 
     * @return A description of the workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultRunProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultRunProperties() {
        return defaultRunProperties != null && !(defaultRunProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of properties to be used as part of each execution of the workflow.
     * </p>
     * <p>
     * Run properties may be logged. Do not pass plaintext secrets as properties. Retrieve secrets from a Glue
     * Connection, Amazon Web Services Secrets Manager or other secret management mechanism if you intend to use them
     * within the workflow run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultRunProperties} method.
     * </p>
     * 
     * @return A collection of properties to be used as part of each execution of the workflow.</p>
     *         <p>
     *         Run properties may be logged. Do not pass plaintext secrets as properties. Retrieve secrets from a Glue
     *         Connection, Amazon Web Services Secrets Manager or other secret management mechanism if you intend to use
     *         them within the workflow run.
     */
    public final Map<String, String> defaultRunProperties() {
        return defaultRunProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to be used with this workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be used with this workflow.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some cases, to
     * prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter
     * blank, there is no limit to the number of concurrent workflow runs.
     * </p>
     * 
     * @return You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some
     *         cases, to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you
     *         leave this parameter blank, there is no limit to the number of concurrent workflow runs.
     */
    public final Integer maxConcurrentRuns() {
        return maxConcurrentRuns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultRunProperties() ? defaultRunProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentRuns());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRequest)) {
            return false;
        }
        CreateWorkflowRequest other = (CreateWorkflowRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasDefaultRunProperties() == other.hasDefaultRunProperties()
                && Objects.equals(defaultRunProperties(), other.defaultRunProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(maxConcurrentRuns(), other.maxConcurrentRuns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkflowRequest").add("Name", name()).add("Description", description())
                .add("DefaultRunProperties", hasDefaultRunProperties() ? defaultRunProperties() : null)
                .add("Tags", hasTags() ? tags() : null).add("MaxConcurrentRuns", maxConcurrentRuns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultRunProperties":
            return Optional.ofNullable(clazz.cast(defaultRunProperties()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "MaxConcurrentRuns":
            return Optional.ofNullable(clazz.cast(maxConcurrentRuns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DefaultRunProperties", DEFAULT_RUN_PROPERTIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("MaxConcurrentRuns", MAX_CONCURRENT_RUNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowRequest, T> g) {
        return obj -> g.apply((CreateWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkflowRequest> {
        /**
         * <p>
         * The name to be assigned to the workflow. It should be unique within your account.
         * </p>
         * 
         * @param name
         *        The name to be assigned to the workflow. It should be unique within your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the workflow.
         * </p>
         * 
         * @param description
         *        A description of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A collection of properties to be used as part of each execution of the workflow.
         * </p>
         * <p>
         * Run properties may be logged. Do not pass plaintext secrets as properties. Retrieve secrets from a Glue
         * Connection, Amazon Web Services Secrets Manager or other secret management mechanism if you intend to use
         * them within the workflow run.
         * </p>
         * 
         * @param defaultRunProperties
         *        A collection of properties to be used as part of each execution of the workflow.</p>
         *        <p>
         *        Run properties may be logged. Do not pass plaintext secrets as properties. Retrieve secrets from a
         *        Glue Connection, Amazon Web Services Secrets Manager or other secret management mechanism if you
         *        intend to use them within the workflow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRunProperties(Map<String, String> defaultRunProperties);

        /**
         * <p>
         * The tags to be used with this workflow.
         * </p>
         * 
         * @param tags
         *        The tags to be used with this workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some cases,
         * to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this
         * parameter blank, there is no limit to the number of concurrent workflow runs.
         * </p>
         * 
         * @param maxConcurrentRuns
         *        You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some
         *        cases, to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you
         *        leave this parameter blank, there is no limit to the number of concurrent workflow runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentRuns(Integer maxConcurrentRuns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private Map<String, String> defaultRunProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer maxConcurrentRuns;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            defaultRunProperties(model.defaultRunProperties);
            tags(model.tags);
            maxConcurrentRuns(model.maxConcurrentRuns);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getDefaultRunProperties() {
            if (defaultRunProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return defaultRunProperties;
        }

        public final void setDefaultRunProperties(Map<String, String> defaultRunProperties) {
            this.defaultRunProperties = WorkflowRunPropertiesCopier.copy(defaultRunProperties);
        }

        @Override
        public final Builder defaultRunProperties(Map<String, String> defaultRunProperties) {
            this.defaultRunProperties = WorkflowRunPropertiesCopier.copy(defaultRunProperties);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final Integer getMaxConcurrentRuns() {
            return maxConcurrentRuns;
        }

        public final void setMaxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
        }

        @Override
        public final Builder maxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowRequest build() {
            return new CreateWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
