/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how Data Quality assets in your account should be encrypted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityEncryption.Builder, DataQualityEncryption> {
    private static final SdkField<String> DATA_QUALITY_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataQualityEncryptionMode").getter(getter(DataQualityEncryption::dataQualityEncryptionModeAsString))
            .setter(setter(Builder::dataQualityEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityEncryptionMode").build())
            .build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(DataQualityEncryption::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_QUALITY_ENCRYPTION_MODE_FIELD, KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataQualityEncryptionMode;

    private final String kmsKeyArn;

    private DataQualityEncryption(BuilderImpl builder) {
        this.dataQualityEncryptionMode = builder.dataQualityEncryptionMode;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The encryption mode to use for encrypting Data Quality assets. These assets include data quality rulesets,
     * results, statistics, anomaly detection models and observations.
     * </p>
     * <p>
     * Valid values are <code>SSEKMS</code> for encryption using a customer-managed KMS key, or <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataQualityEncryptionMode} will return {@link DataQualityEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dataQualityEncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode to use for encrypting Data Quality assets. These assets include data quality
     *         rulesets, results, statistics, anomaly detection models and observations.</p>
     *         <p>
     *         Valid values are <code>SSEKMS</code> for encryption using a customer-managed KMS key, or
     *         <code>DISABLED</code>.
     * @see DataQualityEncryptionMode
     */
    public final DataQualityEncryptionMode dataQualityEncryptionMode() {
        return DataQualityEncryptionMode.fromValue(dataQualityEncryptionMode);
    }

    /**
     * <p>
     * The encryption mode to use for encrypting Data Quality assets. These assets include data quality rulesets,
     * results, statistics, anomaly detection models and observations.
     * </p>
     * <p>
     * Valid values are <code>SSEKMS</code> for encryption using a customer-managed KMS key, or <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataQualityEncryptionMode} will return {@link DataQualityEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dataQualityEncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode to use for encrypting Data Quality assets. These assets include data quality
     *         rulesets, results, statistics, anomaly detection models and observations.</p>
     *         <p>
     *         Valid values are <code>SSEKMS</code> for encryption using a customer-managed KMS key, or
     *         <code>DISABLED</code>.
     * @see DataQualityEncryptionMode
     */
    public final String dataQualityEncryptionModeAsString() {
        return dataQualityEncryptionMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataQualityEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityEncryption)) {
            return false;
        }
        DataQualityEncryption other = (DataQualityEncryption) obj;
        return Objects.equals(dataQualityEncryptionModeAsString(), other.dataQualityEncryptionModeAsString())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityEncryption").add("DataQualityEncryptionMode", dataQualityEncryptionModeAsString())
                .add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataQualityEncryptionMode":
            return Optional.ofNullable(clazz.cast(dataQualityEncryptionModeAsString()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataQualityEncryptionMode", DATA_QUALITY_ENCRYPTION_MODE_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityEncryption, T> g) {
        return obj -> g.apply((DataQualityEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityEncryption> {
        /**
         * <p>
         * The encryption mode to use for encrypting Data Quality assets. These assets include data quality rulesets,
         * results, statistics, anomaly detection models and observations.
         * </p>
         * <p>
         * Valid values are <code>SSEKMS</code> for encryption using a customer-managed KMS key, or
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param dataQualityEncryptionMode
         *        The encryption mode to use for encrypting Data Quality assets. These assets include data quality
         *        rulesets, results, statistics, anomaly detection models and observations.</p>
         *        <p>
         *        Valid values are <code>SSEKMS</code> for encryption using a customer-managed KMS key, or
         *        <code>DISABLED</code>.
         * @see DataQualityEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataQualityEncryptionMode
         */
        Builder dataQualityEncryptionMode(String dataQualityEncryptionMode);

        /**
         * <p>
         * The encryption mode to use for encrypting Data Quality assets. These assets include data quality rulesets,
         * results, statistics, anomaly detection models and observations.
         * </p>
         * <p>
         * Valid values are <code>SSEKMS</code> for encryption using a customer-managed KMS key, or
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param dataQualityEncryptionMode
         *        The encryption mode to use for encrypting Data Quality assets. These assets include data quality
         *        rulesets, results, statistics, anomaly detection models and observations.</p>
         *        <p>
         *        Valid values are <code>SSEKMS</code> for encryption using a customer-managed KMS key, or
         *        <code>DISABLED</code>.
         * @see DataQualityEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataQualityEncryptionMode
         */
        Builder dataQualityEncryptionMode(DataQualityEncryptionMode dataQualityEncryptionMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String dataQualityEncryptionMode;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityEncryption model) {
            dataQualityEncryptionMode(model.dataQualityEncryptionMode);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getDataQualityEncryptionMode() {
            return dataQualityEncryptionMode;
        }

        public final void setDataQualityEncryptionMode(String dataQualityEncryptionMode) {
            this.dataQualityEncryptionMode = dataQualityEncryptionMode;
        }

        @Override
        public final Builder dataQualityEncryptionMode(String dataQualityEncryptionMode) {
            this.dataQualityEncryptionMode = dataQualityEncryptionMode;
            return this;
        }

        @Override
        public final Builder dataQualityEncryptionMode(DataQualityEncryptionMode dataQualityEncryptionMode) {
            this.dataQualityEncryptionMode(dataQualityEncryptionMode == null ? null : dataQualityEncryptionMode.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public DataQualityEncryption build() {
            return new DataQualityEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
