/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityRulesetEvaluationRunFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityRulesetEvaluationRunFilter.Builder, DataQualityRulesetEvaluationRunFilter> {
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(DataQualityRulesetEvaluationRunFilter::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<Instant> STARTED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedBefore").getter(getter(DataQualityRulesetEvaluationRunFilter::startedBefore))
            .setter(setter(Builder::startedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedBefore").build()).build();

    private static final SdkField<Instant> STARTED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAfter").getter(getter(DataQualityRulesetEvaluationRunFilter::startedAfter))
            .setter(setter(Builder::startedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            STARTED_BEFORE_FIELD, STARTED_AFTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataSource dataSource;

    private final Instant startedBefore;

    private final Instant startedAfter;

    private DataQualityRulesetEvaluationRunFilter(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.startedBefore = builder.startedBefore;
        this.startedAfter = builder.startedAfter;
    }

    /**
     * <p>
     * Filter based on a data source (an Glue table) associated with the run.
     * </p>
     * 
     * @return Filter based on a data source (an Glue table) associated with the run.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * Filter results by runs that started before this time.
     * </p>
     * 
     * @return Filter results by runs that started before this time.
     */
    public final Instant startedBefore() {
        return startedBefore;
    }

    /**
     * <p>
     * Filter results by runs that started after this time.
     * </p>
     * 
     * @return Filter results by runs that started after this time.
     */
    public final Instant startedAfter() {
        return startedAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(startedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(startedAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityRulesetEvaluationRunFilter)) {
            return false;
        }
        DataQualityRulesetEvaluationRunFilter other = (DataQualityRulesetEvaluationRunFilter) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(startedBefore(), other.startedBefore())
                && Objects.equals(startedAfter(), other.startedAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityRulesetEvaluationRunFilter").add("DataSource", dataSource())
                .add("StartedBefore", startedBefore()).add("StartedAfter", startedAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "StartedBefore":
            return Optional.ofNullable(clazz.cast(startedBefore()));
        case "StartedAfter":
            return Optional.ofNullable(clazz.cast(startedAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("StartedBefore", STARTED_BEFORE_FIELD);
        map.put("StartedAfter", STARTED_AFTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityRulesetEvaluationRunFilter, T> g) {
        return obj -> g.apply((DataQualityRulesetEvaluationRunFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityRulesetEvaluationRunFilter> {
        /**
         * <p>
         * Filter based on a data source (an Glue table) associated with the run.
         * </p>
         * 
         * @param dataSource
         *        Filter based on a data source (an Glue table) associated with the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * Filter based on a data source (an Glue table) associated with the run.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * Filter results by runs that started before this time.
         * </p>
         * 
         * @param startedBefore
         *        Filter results by runs that started before this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBefore(Instant startedBefore);

        /**
         * <p>
         * Filter results by runs that started after this time.
         * </p>
         * 
         * @param startedAfter
         *        Filter results by runs that started after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAfter(Instant startedAfter);
    }

    static final class BuilderImpl implements Builder {
        private DataSource dataSource;

        private Instant startedBefore;

        private Instant startedAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityRulesetEvaluationRunFilter model) {
            dataSource(model.dataSource);
            startedBefore(model.startedBefore);
            startedAfter(model.startedAfter);
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Instant getStartedBefore() {
            return startedBefore;
        }

        public final void setStartedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
        }

        @Override
        public final Builder startedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
            return this;
        }

        public final Instant getStartedAfter() {
            return startedAfter;
        }

        public final void setStartedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
        }

        @Override
        public final Builder startedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
            return this;
        }

        @Override
        public DataQualityRulesetEvaluationRunFilter build() {
            return new DataQualityRulesetEvaluationRunFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
