/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria used to filter data quality rulesets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityRulesetFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityRulesetFilterCriteria.Builder, DataQualityRulesetFilterCriteria> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DataQualityRulesetFilterCriteria::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DataQualityRulesetFilterCriteria::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedBefore").getter(getter(DataQualityRulesetFilterCriteria::createdBefore))
            .setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()).build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAfter").getter(getter(DataQualityRulesetFilterCriteria::createdAfter))
            .setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedBefore").getter(getter(DataQualityRulesetFilterCriteria::lastModifiedBefore))
            .setter(setter(Builder::lastModifiedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBefore").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedAfter").getter(getter(DataQualityRulesetFilterCriteria::lastModifiedAfter))
            .setter(setter(Builder::lastModifiedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedAfter").build()).build();

    private static final SdkField<DataQualityTargetTable> TARGET_TABLE_FIELD = SdkField
            .<DataQualityTargetTable> builder(MarshallingType.SDK_POJO).memberName("TargetTable")
            .getter(getter(DataQualityRulesetFilterCriteria::targetTable)).setter(setter(Builder::targetTable))
            .constructor(DataQualityTargetTable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CREATED_BEFORE_FIELD, CREATED_AFTER_FIELD,
                    LAST_MODIFIED_BEFORE_FIELD, LAST_MODIFIED_AFTER_FIELD, TARGET_TABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final Instant createdBefore;

    private final Instant createdAfter;

    private final Instant lastModifiedBefore;

    private final Instant lastModifiedAfter;

    private final DataQualityTargetTable targetTable;

    private DataQualityRulesetFilterCriteria(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
        this.lastModifiedBefore = builder.lastModifiedBefore;
        this.lastModifiedAfter = builder.lastModifiedAfter;
        this.targetTable = builder.targetTable;
    }

    /**
     * <p>
     * The name of the ruleset filter criteria.
     * </p>
     * 
     * @return The name of the ruleset filter criteria.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the ruleset filter criteria.
     * </p>
     * 
     * @return The description of the ruleset filter criteria.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Filter on rulesets created before this date.
     * </p>
     * 
     * @return Filter on rulesets created before this date.
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * Filter on rulesets created after this date.
     * </p>
     * 
     * @return Filter on rulesets created after this date.
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * Filter on rulesets last modified before this date.
     * </p>
     * 
     * @return Filter on rulesets last modified before this date.
     */
    public final Instant lastModifiedBefore() {
        return lastModifiedBefore;
    }

    /**
     * <p>
     * Filter on rulesets last modified after this date.
     * </p>
     * 
     * @return Filter on rulesets last modified after this date.
     */
    public final Instant lastModifiedAfter() {
        return lastModifiedAfter;
    }

    /**
     * <p>
     * The name and database name of the target table.
     * </p>
     * 
     * @return The name and database name of the target table.
     */
    public final DataQualityTargetTable targetTable() {
        return targetTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(targetTable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityRulesetFilterCriteria)) {
            return false;
        }
        DataQualityRulesetFilterCriteria other = (DataQualityRulesetFilterCriteria) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(createdBefore(), other.createdBefore()) && Objects.equals(createdAfter(), other.createdAfter())
                && Objects.equals(lastModifiedBefore(), other.lastModifiedBefore())
                && Objects.equals(lastModifiedAfter(), other.lastModifiedAfter())
                && Objects.equals(targetTable(), other.targetTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityRulesetFilterCriteria").add("Name", name()).add("Description", description())
                .add("CreatedBefore", createdBefore()).add("CreatedAfter", createdAfter())
                .add("LastModifiedBefore", lastModifiedBefore()).add("LastModifiedAfter", lastModifiedAfter())
                .add("TargetTable", targetTable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "CreatedAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "LastModifiedBefore":
            return Optional.ofNullable(clazz.cast(lastModifiedBefore()));
        case "LastModifiedAfter":
            return Optional.ofNullable(clazz.cast(lastModifiedAfter()));
        case "TargetTable":
            return Optional.ofNullable(clazz.cast(targetTable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedBefore", CREATED_BEFORE_FIELD);
        map.put("CreatedAfter", CREATED_AFTER_FIELD);
        map.put("LastModifiedBefore", LAST_MODIFIED_BEFORE_FIELD);
        map.put("LastModifiedAfter", LAST_MODIFIED_AFTER_FIELD);
        map.put("TargetTable", TARGET_TABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityRulesetFilterCriteria, T> g) {
        return obj -> g.apply((DataQualityRulesetFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityRulesetFilterCriteria> {
        /**
         * <p>
         * The name of the ruleset filter criteria.
         * </p>
         * 
         * @param name
         *        The name of the ruleset filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the ruleset filter criteria.
         * </p>
         * 
         * @param description
         *        The description of the ruleset filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Filter on rulesets created before this date.
         * </p>
         * 
         * @param createdBefore
         *        Filter on rulesets created before this date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * Filter on rulesets created after this date.
         * </p>
         * 
         * @param createdAfter
         *        Filter on rulesets created after this date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * Filter on rulesets last modified before this date.
         * </p>
         * 
         * @param lastModifiedBefore
         *        Filter on rulesets last modified before this date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBefore(Instant lastModifiedBefore);

        /**
         * <p>
         * Filter on rulesets last modified after this date.
         * </p>
         * 
         * @param lastModifiedAfter
         *        Filter on rulesets last modified after this date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAfter(Instant lastModifiedAfter);

        /**
         * <p>
         * The name and database name of the target table.
         * </p>
         * 
         * @param targetTable
         *        The name and database name of the target table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTable(DataQualityTargetTable targetTable);

        /**
         * <p>
         * The name and database name of the target table.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataQualityTargetTable.Builder} avoiding
         * the need to create one manually via {@link DataQualityTargetTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQualityTargetTable.Builder#build()} is called immediately and
         * its result is passed to {@link #targetTable(DataQualityTargetTable)}.
         * 
         * @param targetTable
         *        a consumer that will call methods on {@link DataQualityTargetTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTable(DataQualityTargetTable)
         */
        default Builder targetTable(Consumer<DataQualityTargetTable.Builder> targetTable) {
            return targetTable(DataQualityTargetTable.builder().applyMutation(targetTable).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private Instant createdBefore;

        private Instant createdAfter;

        private Instant lastModifiedBefore;

        private Instant lastModifiedAfter;

        private DataQualityTargetTable targetTable;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityRulesetFilterCriteria model) {
            name(model.name);
            description(model.description);
            createdBefore(model.createdBefore);
            createdAfter(model.createdAfter);
            lastModifiedBefore(model.lastModifiedBefore);
            lastModifiedAfter(model.lastModifiedAfter);
            targetTable(model.targetTable);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getLastModifiedBefore() {
            return lastModifiedBefore;
        }

        public final void setLastModifiedBefore(Instant lastModifiedBefore) {
            this.lastModifiedBefore = lastModifiedBefore;
        }

        @Override
        public final Builder lastModifiedBefore(Instant lastModifiedBefore) {
            this.lastModifiedBefore = lastModifiedBefore;
            return this;
        }

        public final Instant getLastModifiedAfter() {
            return lastModifiedAfter;
        }

        public final void setLastModifiedAfter(Instant lastModifiedAfter) {
            this.lastModifiedAfter = lastModifiedAfter;
        }

        @Override
        public final Builder lastModifiedAfter(Instant lastModifiedAfter) {
            this.lastModifiedAfter = lastModifiedAfter;
            return this;
        }

        public final DataQualityTargetTable.Builder getTargetTable() {
            return targetTable != null ? targetTable.toBuilder() : null;
        }

        public final void setTargetTable(DataQualityTargetTable.BuilderImpl targetTable) {
            this.targetTable = targetTable != null ? targetTable.build() : null;
        }

        @Override
        public final Builder targetTable(DataQualityTargetTable targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        @Override
        public DataQualityRulesetFilterCriteria build() {
            return new DataQualityRulesetFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
