/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the set of parameters needed to perform the dynamic transform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamicTransform implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamicTransform.Builder, DynamicTransform> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DynamicTransform::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TRANSFORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformName").getter(getter(DynamicTransform::transformName)).setter(setter(Builder::transformName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformName").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(DynamicTransform::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TransformConfigParameter>> PARAMETERS_FIELD = SdkField
            .<List<TransformConfigParameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(DynamicTransform::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransformConfigParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransformConfigParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(DynamicTransform::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(DynamicTransform::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(DynamicTransform::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField
            .<List<GlueSchema>> builder(MarshallingType.LIST)
            .memberName("OutputSchemas")
            .getter(getter(DynamicTransform::outputSchemas))
            .setter(setter(Builder::outputSchemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlueSchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlueSchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TRANSFORM_NAME_FIELD, INPUTS_FIELD, PARAMETERS_FIELD, FUNCTION_NAME_FIELD, PATH_FIELD, VERSION_FIELD,
            OUTPUT_SCHEMAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String transformName;

    private final List<String> inputs;

    private final List<TransformConfigParameter> parameters;

    private final String functionName;

    private final String path;

    private final String version;

    private final List<GlueSchema> outputSchemas;

    private DynamicTransform(BuilderImpl builder) {
        this.name = builder.name;
        this.transformName = builder.transformName;
        this.inputs = builder.inputs;
        this.parameters = builder.parameters;
        this.functionName = builder.functionName;
        this.path = builder.path;
        this.version = builder.version;
        this.outputSchemas = builder.outputSchemas;
    }

    /**
     * <p>
     * Specifies the name of the dynamic transform.
     * </p>
     * 
     * @return Specifies the name of the dynamic transform.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the name of the dynamic transform as it appears in the Glue Studio visual editor.
     * </p>
     * 
     * @return Specifies the name of the dynamic transform as it appears in the Glue Studio visual editor.
     */
    public final String transformName() {
        return transformName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the inputs for the dynamic transform that are required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return Specifies the inputs for the dynamic transform that are required.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the parameters of the dynamic transform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Specifies the parameters of the dynamic transform.
     */
    public final List<TransformConfigParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * Specifies the name of the function of the dynamic transform.
     * </p>
     * 
     * @return Specifies the name of the function of the dynamic transform.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * Specifies the path of the dynamic transform source and config files.
     * </p>
     * 
     * @return Specifies the path of the dynamic transform source and config files.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * This field is not used and will be deprecated in future release.
     * </p>
     * 
     * @return This field is not used and will be deprecated in future release.
     */
    public final String version() {
        return version;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSchemas property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSchemas() {
        return outputSchemas != null && !(outputSchemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the data schema for the dynamic transform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSchemas} method.
     * </p>
     * 
     * @return Specifies the data schema for the dynamic transform.
     */
    public final List<GlueSchema> outputSchemas() {
        return outputSchemas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(transformName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSchemas() ? outputSchemas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicTransform)) {
            return false;
        }
        DynamicTransform other = (DynamicTransform) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(transformName(), other.transformName())
                && hasInputs() == other.hasInputs() && Objects.equals(inputs(), other.inputs())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(functionName(), other.functionName()) && Objects.equals(path(), other.path())
                && Objects.equals(version(), other.version()) && hasOutputSchemas() == other.hasOutputSchemas()
                && Objects.equals(outputSchemas(), other.outputSchemas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynamicTransform").add("Name", name()).add("TransformName", transformName())
                .add("Inputs", hasInputs() ? inputs() : null).add("Parameters", hasParameters() ? parameters() : null)
                .add("FunctionName", functionName()).add("Path", path()).add("Version", version())
                .add("OutputSchemas", hasOutputSchemas() ? outputSchemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TransformName":
            return Optional.ofNullable(clazz.cast(transformName()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "OutputSchemas":
            return Optional.ofNullable(clazz.cast(outputSchemas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("TransformName", TRANSFORM_NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("OutputSchemas", OUTPUT_SCHEMAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DynamicTransform, T> g) {
        return obj -> g.apply((DynamicTransform) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamicTransform> {
        /**
         * <p>
         * Specifies the name of the dynamic transform.
         * </p>
         * 
         * @param name
         *        Specifies the name of the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the name of the dynamic transform as it appears in the Glue Studio visual editor.
         * </p>
         * 
         * @param transformName
         *        Specifies the name of the dynamic transform as it appears in the Glue Studio visual editor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformName(String transformName);

        /**
         * <p>
         * Specifies the inputs for the dynamic transform that are required.
         * </p>
         * 
         * @param inputs
         *        Specifies the inputs for the dynamic transform that are required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * Specifies the inputs for the dynamic transform that are required.
         * </p>
         * 
         * @param inputs
         *        Specifies the inputs for the dynamic transform that are required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * Specifies the parameters of the dynamic transform.
         * </p>
         * 
         * @param parameters
         *        Specifies the parameters of the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<TransformConfigParameter> parameters);

        /**
         * <p>
         * Specifies the parameters of the dynamic transform.
         * </p>
         * 
         * @param parameters
         *        Specifies the parameters of the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(TransformConfigParameter... parameters);

        /**
         * <p>
         * Specifies the parameters of the dynamic transform.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.TransformConfigParameter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.glue.model.TransformConfigParameter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.TransformConfigParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<TransformConfigParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.TransformConfigParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<TransformConfigParameter>)
         */
        Builder parameters(Consumer<TransformConfigParameter.Builder>... parameters);

        /**
         * <p>
         * Specifies the name of the function of the dynamic transform.
         * </p>
         * 
         * @param functionName
         *        Specifies the name of the function of the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * Specifies the path of the dynamic transform source and config files.
         * </p>
         * 
         * @param path
         *        Specifies the path of the dynamic transform source and config files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * This field is not used and will be deprecated in future release.
         * </p>
         * 
         * @param version
         *        This field is not used and will be deprecated in future release.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Specifies the data schema for the dynamic transform.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(Collection<GlueSchema> outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the dynamic transform.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(GlueSchema... outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the dynamic transform.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.GlueSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #outputSchemas(List<GlueSchema>)}.
         * 
         * @param outputSchemas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSchemas(java.util.Collection<GlueSchema>)
         */
        Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String transformName;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<TransformConfigParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private String functionName;

        private String path;

        private String version;

        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicTransform model) {
            name(model.name);
            transformName(model.transformName);
            inputs(model.inputs);
            parameters(model.parameters);
            functionName(model.functionName);
            path(model.path);
            version(model.version);
            outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTransformName() {
            return transformName;
        }

        public final void setTransformName(String transformName) {
            this.transformName = transformName;
        }

        @Override
        public final Builder transformName(String transformName) {
            this.transformName = transformName;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final List<TransformConfigParameter.Builder> getParameters() {
            List<TransformConfigParameter.Builder> result = TransformConfigParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<TransformConfigParameter.BuilderImpl> parameters) {
            this.parameters = TransformConfigParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<TransformConfigParameter> parameters) {
            this.parameters = TransformConfigParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(TransformConfigParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<TransformConfigParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> TransformConfigParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema... outputSchemas) {
            outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas) {
            outputSchemas(Stream.of(outputSchemas).map(c -> GlueSchema.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DynamicTransform build() {
            return new DynamicTransform(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
