/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataQualityModelResultResponse extends GlueResponse implements
        ToCopyableBuilder<GetDataQualityModelResultResponse.Builder, GetDataQualityModelResultResponse> {
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedOn").getter(getter(GetDataQualityModelResultResponse::completedOn))
            .setter(setter(Builder::completedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()).build();

    private static final SdkField<List<StatisticModelResult>> MODEL_FIELD = SdkField
            .<List<StatisticModelResult>> builder(MarshallingType.LIST)
            .memberName("Model")
            .getter(getter(GetDataQualityModelResultResponse::model))
            .setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatisticModelResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatisticModelResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_ON_FIELD,
            MODEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant completedOn;

    private final List<StatisticModelResult> model;

    private GetDataQualityModelResultResponse(BuilderImpl builder) {
        super(builder);
        this.completedOn = builder.completedOn;
        this.model = builder.model;
    }

    /**
     * <p>
     * The timestamp when the data quality model training completed.
     * </p>
     * 
     * @return The timestamp when the data quality model training completed.
     */
    public final Instant completedOn() {
        return completedOn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Model property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasModel() {
        return model != null && !(model instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>StatisticModelResult</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModel} method.
     * </p>
     * 
     * @return A list of <code>StatisticModelResult</code>
     */
    public final List<StatisticModelResult> model() {
        return model;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(hasModel() ? model() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityModelResultResponse)) {
            return false;
        }
        GetDataQualityModelResultResponse other = (GetDataQualityModelResultResponse) obj;
        return Objects.equals(completedOn(), other.completedOn()) && hasModel() == other.hasModel()
                && Objects.equals(model(), other.model());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataQualityModelResultResponse").add("CompletedOn", completedOn())
                .add("Model", hasModel() ? model() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompletedOn":
            return Optional.ofNullable(clazz.cast(completedOn()));
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CompletedOn", COMPLETED_ON_FIELD);
        map.put("Model", MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityModelResultResponse, T> g) {
        return obj -> g.apply((GetDataQualityModelResultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataQualityModelResultResponse> {
        /**
         * <p>
         * The timestamp when the data quality model training completed.
         * </p>
         * 
         * @param completedOn
         *        The timestamp when the data quality model training completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedOn(Instant completedOn);

        /**
         * <p>
         * A list of <code>StatisticModelResult</code>
         * </p>
         * 
         * @param model
         *        A list of <code>StatisticModelResult</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(Collection<StatisticModelResult> model);

        /**
         * <p>
         * A list of <code>StatisticModelResult</code>
         * </p>
         * 
         * @param model
         *        A list of <code>StatisticModelResult</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(StatisticModelResult... model);

        /**
         * <p>
         * A list of <code>StatisticModelResult</code>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.StatisticModelResult.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.StatisticModelResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.StatisticModelResult.Builder#build()} is called immediately
         * and its result is passed to {@link #model(List<StatisticModelResult>)}.
         * 
         * @param model
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.StatisticModelResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #model(java.util.Collection<StatisticModelResult>)
         */
        Builder model(Consumer<StatisticModelResult.Builder>... model);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private Instant completedOn;

        private List<StatisticModelResult> model = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityModelResultResponse model) {
            super(model);
            completedOn(model.completedOn);
            model(model.model);
        }

        public final Instant getCompletedOn() {
            return completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final List<StatisticModelResult.Builder> getModel() {
            List<StatisticModelResult.Builder> result = StatisticModelResultsCopier.copyToBuilder(this.model);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModel(Collection<StatisticModelResult.BuilderImpl> model) {
            this.model = StatisticModelResultsCopier.copyFromBuilder(model);
        }

        @Override
        public final Builder model(Collection<StatisticModelResult> model) {
            this.model = StatisticModelResultsCopier.copy(model);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder model(StatisticModelResult... model) {
            model(Arrays.asList(model));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder model(Consumer<StatisticModelResult.Builder>... model) {
            model(Stream.of(model).map(c -> StatisticModelResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDataQualityModelResultResponse build() {
            return new GetDataQualityModelResultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
