/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobRunRequest extends GlueRequest implements ToCopyableBuilder<GetJobRunRequest.Builder, GetJobRunRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(GetJobRunRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(GetJobRunRequest::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<Boolean> PREDECESSORS_INCLUDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PredecessorsIncluded").getter(getter(GetJobRunRequest::predecessorsIncluded))
            .setter(setter(Builder::predecessorsIncluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredecessorsIncluded").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, RUN_ID_FIELD,
            PREDECESSORS_INCLUDED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobName;

    private final String runId;

    private final Boolean predecessorsIncluded;

    private GetJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.runId = builder.runId;
        this.predecessorsIncluded = builder.predecessorsIncluded;
    }

    /**
     * <p>
     * Name of the job definition being run.
     * </p>
     * 
     * @return Name of the job definition being run.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The ID of the job run.
     * </p>
     * 
     * @return The ID of the job run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * True if a list of predecessor runs should be returned.
     * </p>
     * 
     * @return True if a list of predecessor runs should be returned.
     */
    public final Boolean predecessorsIncluded() {
        return predecessorsIncluded;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(predecessorsIncluded());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobRunRequest)) {
            return false;
        }
        GetJobRunRequest other = (GetJobRunRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(runId(), other.runId())
                && Objects.equals(predecessorsIncluded(), other.predecessorsIncluded());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobRunRequest").add("JobName", jobName()).add("RunId", runId())
                .add("PredecessorsIncluded", predecessorsIncluded()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "PredecessorsIncluded":
            return Optional.ofNullable(clazz.cast(predecessorsIncluded()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobName", JOB_NAME_FIELD);
        map.put("RunId", RUN_ID_FIELD);
        map.put("PredecessorsIncluded", PREDECESSORS_INCLUDED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJobRunRequest, T> g) {
        return obj -> g.apply((GetJobRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetJobRunRequest> {
        /**
         * <p>
         * Name of the job definition being run.
         * </p>
         * 
         * @param jobName
         *        Name of the job definition being run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The ID of the job run.
         * </p>
         * 
         * @param runId
         *        The ID of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * True if a list of predecessor runs should be returned.
         * </p>
         * 
         * @param predecessorsIncluded
         *        True if a list of predecessor runs should be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predecessorsIncluded(Boolean predecessorsIncluded);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String jobName;

        private String runId;

        private Boolean predecessorsIncluded;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobRunRequest model) {
            super(model);
            jobName(model.jobName);
            runId(model.runId);
            predecessorsIncluded(model.predecessorsIncluded);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final Boolean getPredecessorsIncluded() {
            return predecessorsIncluded;
        }

        public final void setPredecessorsIncluded(Boolean predecessorsIncluded) {
            this.predecessorsIncluded = predecessorsIncluded;
        }

        @Override
        public final Builder predecessorsIncluded(Boolean predecessorsIncluded) {
            this.predecessorsIncluded = predecessorsIncluded;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetJobRunRequest build() {
            return new GetJobRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
