/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum JDBCDataType {
    ARRAY("ARRAY"),

    BIGINT("BIGINT"),

    BINARY("BINARY"),

    BIT("BIT"),

    BLOB("BLOB"),

    BOOLEAN("BOOLEAN"),

    CHAR("CHAR"),

    CLOB("CLOB"),

    DATALINK("DATALINK"),

    DATE("DATE"),

    DECIMAL("DECIMAL"),

    DISTINCT("DISTINCT"),

    DOUBLE("DOUBLE"),

    FLOAT("FLOAT"),

    INTEGER("INTEGER"),

    JAVA_OBJECT("JAVA_OBJECT"),

    LONGNVARCHAR("LONGNVARCHAR"),

    LONGVARBINARY("LONGVARBINARY"),

    LONGVARCHAR("LONGVARCHAR"),

    NCHAR("NCHAR"),

    NCLOB("NCLOB"),

    NULL("NULL"),

    NUMERIC("NUMERIC"),

    NVARCHAR("NVARCHAR"),

    OTHER("OTHER"),

    REAL("REAL"),

    REF("REF"),

    REF_CURSOR("REF_CURSOR"),

    ROWID("ROWID"),

    SMALLINT("SMALLINT"),

    SQLXML("SQLXML"),

    STRUCT("STRUCT"),

    TIME("TIME"),

    TIME_WITH_TIMEZONE("TIME_WITH_TIMEZONE"),

    TIMESTAMP("TIMESTAMP"),

    TIMESTAMP_WITH_TIMEZONE("TIMESTAMP_WITH_TIMEZONE"),

    TINYINT("TINYINT"),

    VARBINARY("VARBINARY"),

    VARCHAR("VARCHAR"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JDBCDataType> VALUE_MAP = EnumUtils.uniqueIndex(JDBCDataType.class, JDBCDataType::toString);

    private final String value;

    private JDBCDataType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return JDBCDataType corresponding to the value
     */
    public static JDBCDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link JDBCDataType}s
     */
    public static Set<JDBCDataType> knownValues() {
        Set<JDBCDataType> knownValues = EnumSet.allOf(JDBCDataType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
