/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MappingEntry implements SdkPojo, Serializable, ToCopyableBuilder<MappingEntry.Builder, MappingEntry> {
    private static final SdkField<String> SOURCE_TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceTable").getter(getter(MappingEntry::sourceTable)).setter(setter(Builder::sourceTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTable").build()).build();

    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePath").getter(getter(MappingEntry::sourcePath)).setter(setter(Builder::sourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(MappingEntry::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> TARGET_TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetTable").getter(getter(MappingEntry::targetTable)).setter(setter(Builder::targetTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTable").build()).build();

    private static final SdkField<String> TARGET_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetPath").getter(getter(MappingEntry::targetPath)).setter(setter(Builder::targetPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPath").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(MappingEntry::targetType)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TABLE_FIELD,
            SOURCE_PATH_FIELD, SOURCE_TYPE_FIELD, TARGET_TABLE_FIELD, TARGET_PATH_FIELD, TARGET_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceTable;

    private final String sourcePath;

    private final String sourceType;

    private final String targetTable;

    private final String targetPath;

    private final String targetType;

    private MappingEntry(BuilderImpl builder) {
        this.sourceTable = builder.sourceTable;
        this.sourcePath = builder.sourcePath;
        this.sourceType = builder.sourceType;
        this.targetTable = builder.targetTable;
        this.targetPath = builder.targetPath;
        this.targetType = builder.targetType;
    }

    /**
     * <p>
     * The name of the source table.
     * </p>
     * 
     * @return The name of the source table.
     */
    public final String sourceTable() {
        return sourceTable;
    }

    /**
     * <p>
     * The source path.
     * </p>
     * 
     * @return The source path.
     */
    public final String sourcePath() {
        return sourcePath;
    }

    /**
     * <p>
     * The source type.
     * </p>
     * 
     * @return The source type.
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * <p>
     * The target table.
     * </p>
     * 
     * @return The target table.
     */
    public final String targetTable() {
        return targetTable;
    }

    /**
     * <p>
     * The target path.
     * </p>
     * 
     * @return The target path.
     */
    public final String targetPath() {
        return targetPath;
    }

    /**
     * <p>
     * The target type.
     * </p>
     * 
     * @return The target type.
     */
    public final String targetType() {
        return targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTable());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(targetTable());
        hashCode = 31 * hashCode + Objects.hashCode(targetPath());
        hashCode = 31 * hashCode + Objects.hashCode(targetType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingEntry)) {
            return false;
        }
        MappingEntry other = (MappingEntry) obj;
        return Objects.equals(sourceTable(), other.sourceTable()) && Objects.equals(sourcePath(), other.sourcePath())
                && Objects.equals(sourceType(), other.sourceType()) && Objects.equals(targetTable(), other.targetTable())
                && Objects.equals(targetPath(), other.targetPath()) && Objects.equals(targetType(), other.targetType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MappingEntry").add("SourceTable", sourceTable()).add("SourcePath", sourcePath())
                .add("SourceType", sourceType()).add("TargetTable", targetTable()).add("TargetPath", targetPath())
                .add("TargetType", targetType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceTable":
            return Optional.ofNullable(clazz.cast(sourceTable()));
        case "SourcePath":
            return Optional.ofNullable(clazz.cast(sourcePath()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "TargetTable":
            return Optional.ofNullable(clazz.cast(targetTable()));
        case "TargetPath":
            return Optional.ofNullable(clazz.cast(targetPath()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceTable", SOURCE_TABLE_FIELD);
        map.put("SourcePath", SOURCE_PATH_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("TargetTable", TARGET_TABLE_FIELD);
        map.put("TargetPath", TARGET_PATH_FIELD);
        map.put("TargetType", TARGET_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MappingEntry, T> g) {
        return obj -> g.apply((MappingEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MappingEntry> {
        /**
         * <p>
         * The name of the source table.
         * </p>
         * 
         * @param sourceTable
         *        The name of the source table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTable(String sourceTable);

        /**
         * <p>
         * The source path.
         * </p>
         * 
         * @param sourcePath
         *        The source path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(String sourcePath);

        /**
         * <p>
         * The source type.
         * </p>
         * 
         * @param sourceType
         *        The source type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The target table.
         * </p>
         * 
         * @param targetTable
         *        The target table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTable(String targetTable);

        /**
         * <p>
         * The target path.
         * </p>
         * 
         * @param targetPath
         *        The target path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPath(String targetPath);

        /**
         * <p>
         * The target type.
         * </p>
         * 
         * @param targetType
         *        The target type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetType(String targetType);
    }

    static final class BuilderImpl implements Builder {
        private String sourceTable;

        private String sourcePath;

        private String sourceType;

        private String targetTable;

        private String targetPath;

        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingEntry model) {
            sourceTable(model.sourceTable);
            sourcePath(model.sourcePath);
            sourceType(model.sourceType);
            targetTable(model.targetTable);
            targetPath(model.targetPath);
            targetType(model.targetType);
        }

        public final String getSourceTable() {
            return sourceTable;
        }

        public final void setSourceTable(String sourceTable) {
            this.sourceTable = sourceTable;
        }

        @Override
        public final Builder sourceTable(String sourceTable) {
            this.sourceTable = sourceTable;
            return this;
        }

        public final String getSourcePath() {
            return sourcePath;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final String getTargetTable() {
            return targetTable;
        }

        public final void setTargetTable(String targetTable) {
            this.targetTable = targetTable;
        }

        @Override
        public final Builder targetTable(String targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public final String getTargetPath() {
            return targetPath;
        }

        public final void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        @Override
        public final Builder targetPath(String targetPath) {
            this.targetPath = targetPath;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public MappingEntry build() {
            return new MappingEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
