/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reference to a Glue DataBrew recipe.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecipeReference implements SdkPojo, Serializable, ToCopyableBuilder<RecipeReference.Builder, RecipeReference> {
    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecipeArn").getter(getter(RecipeReference::recipeArn)).setter(setter(Builder::recipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeArn").build()).build();

    private static final SdkField<String> RECIPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecipeVersion").getter(getter(RecipeReference::recipeVersion)).setter(setter(Builder::recipeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPE_ARN_FIELD,
            RECIPE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String recipeArn;

    private final String recipeVersion;

    private RecipeReference(BuilderImpl builder) {
        this.recipeArn = builder.recipeArn;
        this.recipeVersion = builder.recipeVersion;
    }

    /**
     * <p>
     * The ARN of the DataBrew recipe.
     * </p>
     * 
     * @return The ARN of the DataBrew recipe.
     */
    public final String recipeArn() {
        return recipeArn;
    }

    /**
     * <p>
     * The RecipeVersion of the DataBrew recipe.
     * </p>
     * 
     * @return The RecipeVersion of the DataBrew recipe.
     */
    public final String recipeVersion() {
        return recipeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(recipeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipeReference)) {
            return false;
        }
        RecipeReference other = (RecipeReference) obj;
        return Objects.equals(recipeArn(), other.recipeArn()) && Objects.equals(recipeVersion(), other.recipeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecipeReference").add("RecipeArn", recipeArn()).add("RecipeVersion", recipeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecipeArn":
            return Optional.ofNullable(clazz.cast(recipeArn()));
        case "RecipeVersion":
            return Optional.ofNullable(clazz.cast(recipeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecipeArn", RECIPE_ARN_FIELD);
        map.put("RecipeVersion", RECIPE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecipeReference, T> g) {
        return obj -> g.apply((RecipeReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecipeReference> {
        /**
         * <p>
         * The ARN of the DataBrew recipe.
         * </p>
         * 
         * @param recipeArn
         *        The ARN of the DataBrew recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeArn(String recipeArn);

        /**
         * <p>
         * The RecipeVersion of the DataBrew recipe.
         * </p>
         * 
         * @param recipeVersion
         *        The RecipeVersion of the DataBrew recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeVersion(String recipeVersion);
    }

    static final class BuilderImpl implements Builder {
        private String recipeArn;

        private String recipeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(RecipeReference model) {
            recipeArn(model.recipeArn);
            recipeVersion(model.recipeVersion);
        }

        public final String getRecipeArn() {
            return recipeArn;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        @Override
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final String getRecipeVersion() {
            return recipeVersion;
        }

        public final void setRecipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
        }

        @Override
        public final Builder recipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
            return this;
        }

        @Override
        public RecipeReference build() {
            return new RecipeReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
