/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws;

import java.util.Properties;
import org.apache.hudi.aws.credentials.HoodieAWSCredentialsProviderFactory;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.config.HoodieAWSConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class TestHoodieAWSCredentialsProviderFactory {
    @Test
    public void testGetAWSCredentials() {
        HoodieConfig cfg = new HoodieConfig();
        cfg.setValue(HoodieAWSConfig.AWS_ACCESS_KEY, "random-access-key");
        cfg.setValue(HoodieAWSConfig.AWS_SECRET_KEY, "random-secret-key");
        cfg.setValue(HoodieAWSConfig.AWS_SESSION_TOKEN, "random-session-token");
        AwsSessionCredentials credentials = (AwsSessionCredentials)HoodieAWSCredentialsProviderFactory.getAwsCredentialsProvider((Properties)cfg.getProps()).resolveCredentials();
        Assertions.assertEquals((Object)"random-access-key", (Object)credentials.accessKeyId());
        Assertions.assertEquals((Object)"random-secret-key", (Object)credentials.secretAccessKey());
        Assertions.assertEquals((Object)"random-session-token", (Object)credentials.sessionToken());
    }

    @Test
    public void testGetAWSCredentialsWithInvalidAssumeRole() {
        System.setProperty("aws.region", "eu-west-1");
        HoodieConfig cfg = new HoodieConfig();
        cfg.setValue(HoodieAWSConfig.AWS_ACCESS_KEY, "random-access-key");
        cfg.setValue(HoodieAWSConfig.AWS_SECRET_KEY, "random-secret-key");
        cfg.setValue(HoodieAWSConfig.AWS_SESSION_TOKEN, "random-session-token");
        cfg.setValue(HoodieAWSConfig.AWS_ASSUME_ROLE_ARN, "invalid-role-arn");
        AwsSessionCredentials credentials = (AwsSessionCredentials)HoodieAWSCredentialsProviderFactory.getAwsCredentialsProvider((Properties)cfg.getProps()).resolveCredentials();
        System.clearProperty("aws.region");
        Assertions.assertEquals((Object)"random-access-key", (Object)credentials.accessKeyId());
        Assertions.assertEquals((Object)"random-secret-key", (Object)credentials.secretAccessKey());
        Assertions.assertEquals((Object)"random-session-token", (Object)credentials.sessionToken());
    }
}

