/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.metrics.cloudwatch;

import com.codahale.metrics.MetricRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.aws.metrics.cloudwatch.CloudWatchMetricsReporter;
import org.apache.hudi.aws.metrics.cloudwatch.CloudWatchReporter;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.MetricsReporterFactory;
import org.apache.hudi.metrics.MetricsReporterType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class TestCloudWatchMetricsReporter {
    @Mock
    private HoodieWriteConfig writeConfig;
    @Mock
    private HoodieMetricsConfig metricsConfig;
    @Mock
    private MetricRegistry registry;
    @Mock
    private CloudWatchReporter reporter;

    TestCloudWatchMetricsReporter() {
    }

    @Test
    void testReporter() {
        Mockito.when((Object)this.metricsConfig.getCloudWatchReportPeriodSeconds()).thenReturn((Object)30);
        CloudWatchMetricsReporter metricsReporter = new CloudWatchMetricsReporter(this.metricsConfig, this.registry, this.reporter);
        metricsReporter.start();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).start(30L, TimeUnit.SECONDS);
        metricsReporter.report();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).report();
        metricsReporter.stop();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test
    void testReporterUsingMetricsConfig() {
        Mockito.when((Object)this.writeConfig.getMetricsConfig()).thenReturn((Object)this.metricsConfig);
        Mockito.when((Object)this.metricsConfig.getCloudWatchReportPeriodSeconds()).thenReturn((Object)30);
        CloudWatchMetricsReporter metricsReporter = new CloudWatchMetricsReporter(this.writeConfig, this.registry, this.reporter);
        metricsReporter.start();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).start(30L, TimeUnit.SECONDS);
        metricsReporter.report();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).report();
        metricsReporter.stop();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test
    void testReporterViaReporterFactory() {
        try {
            Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.CLOUDWATCH);
            MetricsReporterFactory.createReporter((HoodieMetricsConfig)this.metricsConfig, (MetricRegistry)this.registry).get();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof InvocationTargetException));
            Assertions.assertTrue((boolean)Arrays.stream(((InvocationTargetException)e.getCause()).getTargetException().getStackTrace()).anyMatch(ste -> ste.toString().contains("org.apache.hudi.aws.metrics.cloudwatch.CloudWatchReporter.getAmazonCloudWatchClient")));
        }
    }

    @Test
    void testCreateCloudWatchReporter() {
        Mockito.when((Object)this.metricsConfig.getCloudWatchMetricPrefix()).thenReturn((Object)"prefix");
        Mockito.when((Object)this.metricsConfig.getCloudWatchMetricNamespace()).thenReturn((Object)"namespace");
        Mockito.when((Object)this.metricsConfig.getCloudWatchMaxDatumsPerRequest()).thenReturn((Object)100);
        TypedProperties props = new TypedProperties();
        Mockito.when((Object)this.metricsConfig.getProps()).thenReturn((Object)props);
        CloudWatchReporter reporterMock = (CloudWatchReporter)Mockito.mock(CloudWatchReporter.class);
        CloudWatchReporter.Builder builderMock = (CloudWatchReporter.Builder)Mockito.mock(CloudWatchReporter.Builder.class);
        try (MockedStatic mockedStatic = Mockito.mockStatic(CloudWatchReporter.class);){
            mockedStatic.when(() -> CloudWatchReporter.forRegistry((MetricRegistry)this.registry)).thenReturn((Object)builderMock);
            Mockito.when((Object)builderMock.prefixedWith("prefix")).thenReturn((Object)builderMock);
            Mockito.when((Object)builderMock.namespace("namespace")).thenReturn((Object)builderMock);
            Mockito.when((Object)builderMock.maxDatumsPerRequest(100)).thenReturn((Object)builderMock);
            Mockito.when((Object)builderMock.build((Properties)props)).thenReturn((Object)reporterMock);
            CloudWatchMetricsReporter metricsReporter = new CloudWatchMetricsReporter(this.metricsConfig, this.registry);
            Assertions.assertNotNull((Object)metricsReporter);
        }
    }
}

