/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.metrics.cloudwatch;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.aws.metrics.cloudwatch.CloudWatchReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;

@ExtendWith(value={MockitoExtension.class})
public class TestCloudWatchReporter {
    private static final String NAMESPACE = "Hudi Test";
    private static final String PREFIX = "testPrefix";
    private static final String TABLE_NAME = "testTable";
    private static final int MAX_DATUMS_PER_REQUEST = 2;
    @Mock
    MetricRegistry metricRegistry;
    @Mock(lenient=true)
    CloudWatchAsyncClient cloudWatchAsync;
    @Mock
    CompletableFuture<PutMetricDataResponse> cloudWatchFuture;
    @Captor
    ArgumentCaptor<PutMetricDataRequest> putMetricDataRequestCaptor;
    CloudWatchReporter reporter;

    @BeforeEach
    public void setup() {
        this.reporter = CloudWatchReporter.forRegistry((MetricRegistry)this.metricRegistry).namespace(NAMESPACE).prefixedWith(PREFIX).maxDatumsPerRequest(2).withClock(Clock.defaultClock()).filter(MetricFilter.ALL).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(this.cloudWatchAsync);
        Mockito.when((Object)this.cloudWatchAsync.putMetricData((PutMetricDataRequest)ArgumentMatchers.any())).thenReturn(this.cloudWatchFuture);
    }

    @Test
    public void testReporter() {
        TreeMap<String, Gauge> gauges = new TreeMap<String, Gauge>();
        Gauge gauge1 = () -> 100L;
        Gauge gauge2 = () -> 100.1;
        gauges.put("testTable.gauge1", gauge1);
        gauges.put("testTable.gauge2", gauge2);
        TreeMap<String, Counter> counters = new TreeMap<String, Counter>();
        Counter counter1 = new Counter();
        counter1.inc(200L);
        counters.put("testTable.counter1", counter1);
        TreeMap<String, Histogram> histograms = new TreeMap<String, Histogram>();
        Histogram histogram1 = new Histogram((Reservoir)new ExponentiallyDecayingReservoir());
        histogram1.update(300);
        histograms.put("testTable.histogram1", histogram1);
        TreeMap<String, Meter> meters = new TreeMap<String, Meter>();
        Meter meter1 = new Meter();
        meter1.mark(400L);
        meters.put("testTable.meter1", meter1);
        TreeMap<String, Timer> timers = new TreeMap<String, Timer>();
        Timer timer1 = new Timer();
        timer1.update(100L, TimeUnit.SECONDS);
        timers.put("testTable.timer1", timer1);
        Mockito.when((Object)this.metricRegistry.getGauges(MetricFilter.ALL)).thenReturn(gauges);
        Mockito.when((Object)this.metricRegistry.getCounters(MetricFilter.ALL)).thenReturn(counters);
        Mockito.when((Object)this.metricRegistry.getHistograms(MetricFilter.ALL)).thenReturn(histograms);
        Mockito.when((Object)this.metricRegistry.getMeters(MetricFilter.ALL)).thenReturn(meters);
        Mockito.when((Object)this.metricRegistry.getTimers(MetricFilter.ALL)).thenReturn(timers);
        this.reporter.report();
        ((CloudWatchAsyncClient)Mockito.verify((Object)this.cloudWatchAsync, (VerificationMode)Mockito.times((int)3))).putMetricData((PutMetricDataRequest)this.putMetricDataRequestCaptor.capture());
        Assertions.assertEquals((Object)NAMESPACE, (Object)((PutMetricDataRequest)this.putMetricDataRequestCaptor.getValue()).namespace());
        List putMetricDataRequests = this.putMetricDataRequestCaptor.getAllValues();
        putMetricDataRequests.forEach(request -> Assertions.assertEquals((int)2, (int)request.metricData().size()));
        List metricDataBatch1 = ((PutMetricDataRequest)putMetricDataRequests.get(0)).metricData();
        Assertions.assertEquals((Object)"testPrefix.gauge1", (Object)((MetricDatum)metricDataBatch1.get(0)).metricName());
        Assertions.assertEquals((Double)((Object)((Long)gauge1.getValue())), (Double)((MetricDatum)metricDataBatch1.get(0)).value());
        this.assertDimensions(((MetricDatum)metricDataBatch1.get(0)).dimensions(), "gauge");
        Assertions.assertEquals((Object)"testPrefix.gauge2", (Object)((MetricDatum)metricDataBatch1.get(1)).metricName());
        Assertions.assertEquals((Double)((Double)gauge2.getValue()), (Double)((MetricDatum)metricDataBatch1.get(1)).value());
        this.assertDimensions(((MetricDatum)metricDataBatch1.get(1)).dimensions(), "gauge");
        List metricDataBatch2 = ((PutMetricDataRequest)putMetricDataRequests.get(1)).metricData();
        Assertions.assertEquals((Object)"testPrefix.counter1", (Object)((MetricDatum)metricDataBatch2.get(0)).metricName());
        Assertions.assertEquals((long)counter1.getCount(), (long)((MetricDatum)metricDataBatch2.get(0)).value().longValue());
        this.assertDimensions(((MetricDatum)metricDataBatch2.get(0)).dimensions(), "count");
        Assertions.assertEquals((Object)"testPrefix.histogram1", (Object)((MetricDatum)metricDataBatch2.get(1)).metricName());
        Assertions.assertEquals((long)histogram1.getCount(), (long)((MetricDatum)metricDataBatch2.get(1)).value().longValue());
        this.assertDimensions(((MetricDatum)metricDataBatch2.get(1)).dimensions(), "count");
        List metricDataBatch3 = ((PutMetricDataRequest)putMetricDataRequests.get(2)).metricData();
        Assertions.assertEquals((Object)"testPrefix.meter1", (Object)((MetricDatum)metricDataBatch3.get(0)).metricName());
        Assertions.assertEquals((long)meter1.getCount(), (long)((MetricDatum)metricDataBatch3.get(0)).value().longValue());
        this.assertDimensions(((MetricDatum)metricDataBatch3.get(0)).dimensions(), "count");
        Assertions.assertEquals((Object)"testPrefix.timer1", (Object)((MetricDatum)metricDataBatch3.get(1)).metricName());
        Assertions.assertEquals((long)timer1.getCount(), (long)((MetricDatum)metricDataBatch3.get(1)).value().longValue());
        this.assertDimensions(((MetricDatum)metricDataBatch3.get(1)).dimensions(), "count");
        this.reporter.stop();
        ((CloudWatchAsyncClient)Mockito.verify((Object)this.cloudWatchAsync)).close();
    }

    @Test
    public void testReportOnMetricsWithoutTableName() {
        TreeMap<String, Gauge> gauges = new TreeMap<String, Gauge>();
        Gauge gauge1 = () -> 100L;
        Gauge gauge2 = () -> 100.1;
        gauges.put("gauge1", gauge1);
        gauges.put("testTable.gauge2", gauge2);
        Mockito.when((Object)this.metricRegistry.getGauges(MetricFilter.ALL)).thenReturn(gauges);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.reporter.report());
        this.reporter.stop();
        ((CloudWatchAsyncClient)Mockito.verify((Object)this.cloudWatchAsync)).close();
    }

    private void assertDimensions(List<Dimension> actualDimensions, String metricTypeDimensionVal) {
        Assertions.assertEquals((int)2, (int)actualDimensions.size());
        Dimension expectedTableNameDimension = (Dimension)Dimension.builder().name("Table").value(TABLE_NAME).build();
        Dimension expectedMetricTypeDimension = (Dimension)Dimension.builder().name("Metric Type").value(metricTypeDimensionVal).build();
        Assertions.assertEquals((Object)expectedTableNameDimension, (Object)actualDimensions.get(0));
        Assertions.assertEquals((Object)expectedMetricTypeDimension, (Object)actualDimensions.get(1));
    }
}

