/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.sync;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.aws.sync.AWSGlueCatalogSyncClient;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.config.HoodieAWSConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.DatabaseInput;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.PartitionInput;
import software.amazon.awssdk.services.glue.model.SerDeInfo;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.TableInput;

@Disabled(value="HUDI-7475 The tests do not work. Disabling them to unblock Azure CI")
public class ITTestGluePartitionPushdown {
    private static final int MOTO_PORT = 5002;
    private static final String MOTO_ENDPOINT = "http://localhost:5002";
    private static final String DB_NAME = "db_name";
    private static final String TABLE_NAME = "tbl_name";
    private String basePath = Files.createTempDirectory("hivesynctest" + Instant.now().toEpochMilli(), new FileAttribute[0]).toUri().toString();
    private String tablePath = this.basePath + "/" + "tbl_name";
    private TypedProperties hiveSyncProps;
    private AWSGlueCatalogSyncClient glueSync;
    private FileSystem fileSystem;
    private Column[] partitionsColumn = new Column[]{(Column)Column.builder().name("part1").type("int").build(), (Column)Column.builder().name("part2").type("string").build()};
    List<FieldSchema> partitionsFieldSchema = Arrays.asList(new FieldSchema("part1", "int"), new FieldSchema("part2", "string"));

    @BeforeEach
    public void setUp() throws Exception {
        this.hiveSyncProps = new TypedProperties();
        this.hiveSyncProps.setProperty(HoodieAWSConfig.AWS_ACCESS_KEY.key(), "dummy");
        this.hiveSyncProps.setProperty(HoodieAWSConfig.AWS_SECRET_KEY.key(), "dummy");
        this.hiveSyncProps.setProperty(HoodieAWSConfig.AWS_SESSION_TOKEN.key(), "dummy");
        this.hiveSyncProps.setProperty(HoodieAWSConfig.AWS_GLUE_ENDPOINT.key(), MOTO_ENDPOINT);
        this.hiveSyncProps.setProperty(HoodieAWSConfig.AWS_GLUE_REGION.key(), "eu-west-1");
        this.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), this.tablePath);
        this.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), DB_NAME);
        HiveSyncConfig hiveSyncConfig = new HiveSyncConfig((Properties)this.hiveSyncProps, new Configuration());
        this.fileSystem = hiveSyncConfig.getHadoopFileSystem();
        this.fileSystem.mkdirs(new Path(this.tablePath));
        StorageConfiguration configuration = HadoopFSUtils.getStorageConf((Configuration)new Configuration());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.COPY_ON_WRITE).setTableName(TABLE_NAME).setPayloadClass(HoodieAvroPayload.class).initTable(configuration, this.tablePath);
        this.glueSync = new AWSGlueCatalogSyncClient(new HiveSyncConfig((Properties)this.hiveSyncProps), metaClient);
        this.glueSync.awsGlue.createDatabase((CreateDatabaseRequest)CreateDatabaseRequest.builder().databaseInput((DatabaseInput)DatabaseInput.builder().name(DB_NAME).build()).build()).get();
        this.glueSync.awsGlue.createTable((CreateTableRequest)CreateTableRequest.builder().databaseName(DB_NAME).tableInput((TableInput)TableInput.builder().name(TABLE_NAME).partitionKeys(this.partitionsColumn).storageDescriptor((StorageDescriptor)StorageDescriptor.builder().serdeInfo((SerDeInfo)SerDeInfo.builder().serializationLibrary("").build()).location(this.tablePath).columns(new Column[]{(Column)Column.builder().name("col1").type("string").build()}).build()).build()).build()).get();
    }

    @AfterEach
    public void teardown() throws Exception {
        this.glueSync.awsGlue.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().databaseName(DB_NAME).name(TABLE_NAME).build()).get();
        this.glueSync.awsGlue.deleteDatabase((DeleteDatabaseRequest)DeleteDatabaseRequest.builder().name(DB_NAME).build()).get();
        this.fileSystem.delete(new Path(this.tablePath), true);
    }

    private void createPartitions(String ... partitions) throws ExecutionException, InterruptedException {
        this.glueSync.awsGlue.createPartition((CreatePartitionRequest)CreatePartitionRequest.builder().databaseName(DB_NAME).tableName(TABLE_NAME).partitionInput((PartitionInput)PartitionInput.builder().storageDescriptor((StorageDescriptor)StorageDescriptor.builder().columns(this.partitionsColumn).build()).values(partitions).build()).build()).get();
    }

    @Test
    public void testEmptyPartitionShouldReturnEmpty() {
        Assertions.assertEquals((int)0, (int)this.glueSync.getPartitionsFromList(TABLE_NAME, Arrays.asList("1/bar")).size());
    }

    @Test
    public void testPresentPartitionShouldReturnIt() throws ExecutionException, InterruptedException {
        this.createPartitions("1", "b'ar");
        Assertions.assertEquals((int)1, (int)this.glueSync.getPartitionsFromList(TABLE_NAME, Arrays.asList("1/b'ar", "2/foo", "1/b''ar")).size());
    }
}

