/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.sync;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.hudi.aws.sync.AWSGlueCatalogSyncClient;
import org.apache.hudi.aws.sync.HoodieGlueSyncException;
import org.apache.hudi.aws.testutils.GlueTestUtil;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.apache.parquet.schema.MessageType;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.CreateTableResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableResponse;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.SerDeInfo;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateTableResponse;

@ExtendWith(value={MockitoExtension.class})
class TestAWSGlueSyncClient {
    @Mock
    private GlueAsyncClient mockAwsGlue;
    private AWSGlueCatalogSyncClient awsGlueSyncClient;

    TestAWSGlueSyncClient() {
    }

    @BeforeEach
    void setUp() throws IOException {
        GlueTestUtil.setUp();
        this.awsGlueSyncClient = new AWSGlueCatalogSyncClient(this.mockAwsGlue, GlueTestUtil.getHiveSyncConfig(), GlueTestUtil.getMetaClient());
    }

    @AfterEach
    void clear() throws IOException {
        GlueTestUtil.clear();
    }

    @AfterAll
    static void cleanUp() throws IOException {
        GlueTestUtil.teardown();
    }

    @Test
    void testCreateOrReplaceTable_TableExists() throws ExecutionException, InterruptedException {
        String tableName = "testTable";
        String databaseName = "testdb";
        String inputFormatClass = "inputFormat";
        MessageType storageSchema = GlueTestUtil.getSimpleSchema();
        String outputFormatClass = "outputFormat";
        String serdeClass = "serde";
        HashMap serdeProperties = new HashMap();
        HashMap tableProperties = new HashMap();
        StorageDescriptor storageDescriptor = (StorageDescriptor)StorageDescriptor.builder().serdeInfo((SerDeInfo)SerDeInfo.builder().serializationLibrary(serdeClass).parameters(serdeProperties).build()).inputFormat(inputFormatClass).outputFormat(outputFormatClass).build();
        Table table = (Table)Table.builder().name(tableName).tableType("COPY_ON_WRITE").parameters(new HashMap()).storageDescriptor(storageDescriptor).databaseName(databaseName).build();
        GetTableResponse tableResponse = (GetTableResponse)GetTableResponse.builder().table(table).build();
        GetTableRequest getTableRequestForTable = (GetTableRequest)GetTableRequest.builder().databaseName(databaseName).name(tableName).build();
        CompletableFuture<GetTableResponse> tableResponseFuture = CompletableFuture.completedFuture(tableResponse);
        CompletableFuture mockTableNotFoundResponse = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        ExecutionException executionException = new ExecutionException("failed to get table", (Throwable)EntityNotFoundException.builder().build());
        Mockito.when(mockTableNotFoundResponse.get()).thenThrow(new Throwable[]{executionException});
        Mockito.when((Object)this.mockAwsGlue.getTable((GetTableRequest)Mockito.any(GetTableRequest.class))).thenReturn((Object)mockTableNotFoundResponse);
        Mockito.when((Object)this.mockAwsGlue.getTable(getTableRequestForTable)).thenReturn(tableResponseFuture).thenReturn((Object)mockTableNotFoundResponse);
        Mockito.when((Object)this.mockAwsGlue.createTable((CreateTableRequest)Mockito.any(CreateTableRequest.class))).thenReturn(CompletableFuture.completedFuture(CreateTableResponse.builder().build()));
        CompletableFuture<Object> deleteTableResponse = CompletableFuture.completedFuture(DeleteTableResponse.builder().build());
        Mockito.when((Object)this.mockAwsGlue.deleteTable((DeleteTableRequest)Mockito.any(DeleteTableRequest.class))).thenReturn(deleteTableResponse);
        this.awsGlueSyncClient.createOrReplaceTable(tableName, storageSchema, inputFormatClass, outputFormatClass, serdeClass, serdeProperties, tableProperties);
        ((GlueAsyncClient)Mockito.verify((Object)this.mockAwsGlue, (VerificationMode)Mockito.times((int)2))).deleteTable((DeleteTableRequest)Mockito.any(DeleteTableRequest.class));
        ((GlueAsyncClient)Mockito.verify((Object)this.mockAwsGlue, (VerificationMode)Mockito.times((int)3))).getTable((GetTableRequest)Mockito.any(GetTableRequest.class));
        ((GlueAsyncClient)Mockito.verify((Object)this.mockAwsGlue, (VerificationMode)Mockito.times((int)2))).createTable((CreateTableRequest)Mockito.any(CreateTableRequest.class));
    }

    @Test
    void testCreateOrReplaceTable_TableDoesNotExist() {
        String tableName = "testTable";
        MessageType storageSchema = GlueTestUtil.getSimpleSchema();
        String inputFormatClass = "inputFormat";
        String outputFormatClass = "outputFormat";
        String serdeClass = "serde";
        HashMap serdeProperties = new HashMap();
        HashMap tableProperties = new HashMap();
        CompletableFuture<Object> tableResponse = CompletableFuture.completedFuture(GetTableResponse.builder().build());
        Mockito.when((Object)this.mockAwsGlue.getTable((GetTableRequest)Mockito.any(GetTableRequest.class))).thenReturn(tableResponse);
        CompletableFuture<Object> createTableResponse = CompletableFuture.completedFuture(CreateTableResponse.builder().build());
        Mockito.when((Object)this.mockAwsGlue.createTable((CreateTableRequest)Mockito.any(CreateTableRequest.class))).thenReturn(createTableResponse);
        this.awsGlueSyncClient.createOrReplaceTable(tableName, storageSchema, inputFormatClass, outputFormatClass, serdeClass, serdeProperties, tableProperties);
        ((GlueAsyncClient)Mockito.verify((Object)this.mockAwsGlue, (VerificationMode)Mockito.times((int)1))).createTable((CreateTableRequest)Mockito.any(CreateTableRequest.class));
    }

    @Test
    void testDropTable() {
        DeleteTableResponse response = (DeleteTableResponse)DeleteTableResponse.builder().build();
        CompletableFuture<DeleteTableResponse> future = CompletableFuture.completedFuture(response);
        Mockito.when((Object)this.mockAwsGlue.deleteTable((DeleteTableRequest)Mockito.any(DeleteTableRequest.class))).thenReturn(future);
        this.awsGlueSyncClient.dropTable("test");
        ((GlueAsyncClient)Mockito.verify((Object)this.mockAwsGlue, (VerificationMode)Mockito.times((int)1))).deleteTable((DeleteTableRequest)Mockito.any(DeleteTableRequest.class));
    }

    @Test
    void testMetastoreFieldSchemas() {
        String tableName = "testTable";
        List<Column> columns = Arrays.asList(GlueTestUtil.getColumn("name", "string", "person's name"), GlueTestUtil.getColumn("age", "int", "person's age"));
        List<Column> partitionKeys = Arrays.asList(GlueTestUtil.getColumn("city", "string", "person's city"));
        CompletableFuture<GetTableResponse> tableResponse = this.getTableWithDefaultProps(tableName, columns, partitionKeys);
        Mockito.when((Object)this.mockAwsGlue.getTable((GetTableRequest)Mockito.any(GetTableRequest.class))).thenReturn(tableResponse);
        List fields = this.awsGlueSyncClient.getMetastoreFieldSchemas(tableName);
        Assertions.assertEquals((int)3, (int)fields.size(), (String)"Glue table schema contain 3 fields");
        Assertions.assertEquals((Object)"name", (Object)((FieldSchema)fields.get(0)).getName(), (String)"glue table first column should be name");
        Assertions.assertEquals((Object)"string", (Object)((FieldSchema)fields.get(0)).getType(), (String)"glue table first column type should be string");
        Assertions.assertEquals((Object)"person's name", (Object)((FieldSchema)fields.get(0)).getComment().get(), (String)"glue table first column comment should person's name");
        Assertions.assertEquals((Object)"age", (Object)((FieldSchema)fields.get(1)).getName(), (String)"glue table second column should be age");
        Assertions.assertEquals((Object)"int", (Object)((FieldSchema)fields.get(1)).getType(), (String)"glue table second column type should be int");
        Assertions.assertEquals((Object)"person's age", (Object)((FieldSchema)fields.get(1)).getComment().get(), (String)"glue table second column comment should person's age");
        Assertions.assertEquals((Object)"city", (Object)((FieldSchema)fields.get(2)).getName(), (String)"glue table third column should be city");
        Assertions.assertEquals((Object)"string", (Object)((FieldSchema)fields.get(2)).getType(), (String)"glue table third column type should be string");
        Assertions.assertEquals((Object)"person's city", (Object)((FieldSchema)fields.get(2)).getComment().get(), (String)"glue table third column comment should be person's city");
    }

    @Test
    void testMetastoreFieldSchemas_EmptyPartitions() {
        String tableName = "testTable";
        List<Column> columns = Arrays.asList(GlueTestUtil.getColumn("name", "string", "person's name"), GlueTestUtil.getColumn("age", "int", "person's age"));
        CompletableFuture<GetTableResponse> tableResponse = this.getTableWithDefaultProps(tableName, columns, Collections.emptyList());
        Mockito.when((Object)this.mockAwsGlue.getTable((GetTableRequest)Mockito.any(GetTableRequest.class))).thenReturn(tableResponse);
        List fields = this.awsGlueSyncClient.getMetastoreFieldSchemas(tableName);
        Assertions.assertEquals((int)2, (int)fields.size(), (String)"Glue table schema contain 3 fields");
        Assertions.assertEquals((Object)"name", (Object)((FieldSchema)fields.get(0)).getName(), (String)"glue table first column should be name");
        Assertions.assertEquals((Object)"string", (Object)((FieldSchema)fields.get(0)).getType(), (String)"glue table first column type should be string");
        Assertions.assertEquals((Object)"person's name", (Object)((FieldSchema)fields.get(0)).getComment().get(), (String)"glue table first column comment should person's name");
        Assertions.assertEquals((Object)"age", (Object)((FieldSchema)fields.get(1)).getName(), (String)"glue table second column should be age");
        Assertions.assertEquals((Object)"int", (Object)((FieldSchema)fields.get(1)).getType(), (String)"glue table second column type should be int");
        Assertions.assertEquals((Object)"person's age", (Object)((FieldSchema)fields.get(1)).getComment().get(), (String)"glue table second column comment should person's age");
    }

    @Test
    void testMetastoreFieldSchemas_ExceptionThrows() {
        String tableName = "testTable";
        Mockito.when((Object)this.mockAwsGlue.getTable((GetTableRequest)Mockito.any(GetTableRequest.class))).thenThrow(EntityNotFoundException.class);
        Assertions.assertThrows(HoodieGlueSyncException.class, () -> this.awsGlueSyncClient.getMetastoreFieldSchemas(tableName));
    }

    @Test
    void testGetTableLocation() {
        String tableName = "testTable";
        List<Column> columns = Arrays.asList((Column)Column.builder().name("name").type("string").comment("person's name").build(), (Column)Column.builder().name("age").type("int").comment("person's age").build());
        CompletableFuture<GetTableResponse> tableResponse = this.getTableWithDefaultProps(tableName, columns, Collections.emptyList());
        Mockito.when((Object)this.mockAwsGlue.getTable((GetTableRequest)Mockito.any(GetTableRequest.class))).thenReturn(tableResponse);
        String basePath = this.awsGlueSyncClient.getTableLocation(tableName);
        Assertions.assertEquals((Object)GlueTestUtil.glueSyncProps.get((Object)HoodieSyncConfig.META_SYNC_BASE_PATH.key()), (Object)basePath, (String)"table base path should match");
    }

    @Test
    void testGetTableLocation_ThrowsException() {
        String tableName = "testTable";
        Mockito.when((Object)this.mockAwsGlue.getTable((GetTableRequest)Mockito.any(GetTableRequest.class))).thenThrow(EntityNotFoundException.class);
        Assertions.assertThrows(HoodieGlueSyncException.class, () -> this.awsGlueSyncClient.getTableLocation(tableName));
    }

    @Test
    void testUpdateTableProperties() throws ExecutionException, InterruptedException {
        String tableName = "test";
        GlueTestUtil.getColumn("name", "string", "person's name");
        List<Column> columns = Arrays.asList(GlueTestUtil.getColumn("name", "string", "person's name"), GlueTestUtil.getColumn("age", "int", "person's age"));
        List<Column> partitionKeys = Collections.singletonList(GlueTestUtil.getColumn("city", "string", "person's city"));
        CompletableFuture<GetTableResponse> tableResponseFuture = this.getTableWithDefaultProps(tableName, columns, partitionKeys);
        HashMap<String, String> newTableProperties = new HashMap<String, String>();
        newTableProperties.put("last_commit_time_sync", "100");
        CompletableFuture mockUpdateTableResponse = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        Mockito.when(mockUpdateTableResponse.get()).thenReturn(UpdateTableResponse.builder().build());
        Mockito.when((Object)this.mockAwsGlue.getTable((GetTableRequest)Mockito.any(GetTableRequest.class))).thenReturn(tableResponseFuture);
        Mockito.when((Object)this.mockAwsGlue.updateTable((UpdateTableRequest)Mockito.any(UpdateTableRequest.class))).thenReturn((Object)mockUpdateTableResponse);
        boolean updated = this.awsGlueSyncClient.updateTableProperties(tableName, newTableProperties);
        Assertions.assertTrue((boolean)updated, (String)"should return true when new parameters is not empty");
        ((GlueAsyncClient)Mockito.verify((Object)this.mockAwsGlue, (VerificationMode)Mockito.times((int)1))).updateTable((UpdateTableRequest)Mockito.any(UpdateTableRequest.class));
        Mockito.when(mockUpdateTableResponse.get()).thenThrow(new Throwable[]{new InterruptedException()});
        Assertions.assertThrows(HoodieGlueSyncException.class, () -> this.awsGlueSyncClient.updateTableProperties(tableName, (Map)newTableProperties));
    }

    private CompletableFuture<GetTableResponse> getTableWithDefaultProps(String tableName, List<Column> columns, List<Column> partitionColumns) {
        String databaseName = "testdb";
        String inputFormatClass = "inputFormat";
        String outputFormatClass = "outputFormat";
        String serdeClass = "serde";
        HashMap serdeProperties = new HashMap();
        HashMap tableProperties = new HashMap();
        StorageDescriptor storageDescriptor = (StorageDescriptor)StorageDescriptor.builder().serdeInfo((SerDeInfo)SerDeInfo.builder().serializationLibrary(serdeClass).parameters(serdeProperties).build()).inputFormat(inputFormatClass).location(GlueTestUtil.glueSyncProps.getString(HoodieSyncConfig.META_SYNC_BASE_PATH.key())).columns(columns).outputFormat(outputFormatClass).build();
        Table table = (Table)Table.builder().name(tableName).tableType("COPY_ON_WRITE").parameters(new HashMap()).storageDescriptor(storageDescriptor).partitionKeys(partitionColumns).parameters(tableProperties).databaseName(databaseName).build();
        GetTableResponse response = (GetTableResponse)GetTableResponse.builder().table(table).build();
        return CompletableFuture.completedFuture(response);
    }
}

