/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.sync;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.aws.sync.AwsGlueCatalogSyncTool;
import org.apache.hudi.aws.sync.MockAwsGlueCatalogSyncTool;
import org.apache.hudi.aws.testutils.GlueTestUtil;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.GlueCatalogSyncClientConfig;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncTool;
import org.apache.hudi.sync.common.util.SyncUtilHelpers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.GlueAsyncClientBuilder;

@ExtendWith(value={MockitoExtension.class})
class TestAwsGlueSyncTool {
    private AwsGlueCatalogSyncTool awsGlueCatalogSyncTool;

    TestAwsGlueSyncTool() {
    }

    @BeforeEach
    void setUp() throws IOException {
        GlueTestUtil.setUp();
        this.awsGlueCatalogSyncTool = new MockAwsGlueCatalogSyncTool((Properties)GlueTestUtil.glueSyncProps, GlueTestUtil.getHadoopConf());
    }

    @AfterEach
    void clean() throws IOException {
        GlueTestUtil.clear();
    }

    @AfterAll
    public static void cleanUp() throws IOException {
        GlueTestUtil.teardown();
    }

    @Test
    void testShouldRecreateAndSyncTableOverride() {
        GlueTestUtil.glueSyncProps.setProperty(HiveSyncConfig.RECREATE_HIVE_TABLE_ON_ERROR.key(), "false");
        GlueTestUtil.glueSyncProps.setProperty(GlueCatalogSyncClientConfig.RECREATE_GLUE_TABLE_ON_ERROR.key(), "true");
        this.reinitGlueSyncTool();
        Assertions.assertTrue((boolean)this.awsGlueCatalogSyncTool.shouldRecreateAndSyncTable(), (String)"recreate_table_on_error should be true for glue");
    }

    private void reinitGlueSyncTool() {
        this.awsGlueCatalogSyncTool = new MockAwsGlueCatalogSyncTool((Properties)GlueTestUtil.glueSyncProps, GlueTestUtil.getHadoopConf());
    }

    @Test
    void validateInitThroughSyncTool() throws Exception {
        try (MockedStatic mockedStatic = Mockito.mockStatic(GlueAsyncClient.class);){
            GlueAsyncClientBuilder builder = (GlueAsyncClientBuilder)Mockito.mock(GlueAsyncClientBuilder.class);
            mockedStatic.when(GlueAsyncClient::builder).thenReturn((Object)builder);
            Mockito.when((Object)builder.credentialsProvider((AwsCredentialsProvider)ArgumentMatchers.any())).thenReturn((Object)builder);
            GlueAsyncClient mockClient = (GlueAsyncClient)Mockito.mock(GlueAsyncClient.class);
            Mockito.when((Object)builder.build()).thenReturn((Object)mockClient);
            HoodieSyncTool syncTool = SyncUtilHelpers.instantiateMetaSyncTool((String)AwsGlueCatalogSyncTool.class.getName(), (TypedProperties)new TypedProperties(), (Configuration)GlueTestUtil.getHadoopConf(), (FileSystem)GlueTestUtil.fileSystem, (String)GlueTestUtil.getMetaClient().getBasePath().toString(), (String)"PARQUET", (Option)Option.empty());
            Assertions.assertTrue((boolean)(syncTool instanceof AwsGlueCatalogSyncTool));
            syncTool.close();
        }
    }
}

