/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.testutils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.DefaultInstantFileNameGenerator;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.SlashEncodedDayPartitionValueExtractor;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import software.amazon.awssdk.services.glue.model.Column;

public class GlueTestUtil {
    public static TypedProperties glueSyncProps;
    private static final String DB_NAME = "testdb";
    private static final String TABLE_NAME = "test1";
    private static String basePath;
    public static FileSystem fileSystem;
    private static HiveSyncConfig hiveSyncConfig;
    private static Configuration hadoopConf;
    private static HoodieTableMetaClient metaClient;

    public static void setUp() throws IOException {
        basePath = Files.createTempDirectory("glueClientTest" + Instant.now().toEpochMilli(), new FileAttribute[0]).toUri().toString();
        glueSyncProps = new TypedProperties();
        glueSyncProps.setProperty(HiveSyncConfigHolder.HIVE_USER.key(), "");
        glueSyncProps.setProperty(HiveSyncConfigHolder.HIVE_PASS.key(), "");
        glueSyncProps.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), DB_NAME);
        glueSyncProps.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), TABLE_NAME);
        glueSyncProps.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), basePath);
        glueSyncProps.setProperty(HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT.key(), "false");
        glueSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), SlashEncodedDayPartitionValueExtractor.class.getName());
        glueSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "datestr");
        glueSyncProps.setProperty(HiveSyncConfigHolder.HIVE_BATCH_SYNC_PARTITION_NUM.key(), "3");
        hiveSyncConfig = new HiveSyncConfig((Properties)glueSyncProps);
        fileSystem = hiveSyncConfig.getHadoopFileSystem();
        hadoopConf = HadoopFSUtils.getFs((String)glueSyncProps.getString(HoodieSyncConfig.META_SYNC_BASE_PATH.key()), (Configuration)new Configuration()).getConf();
        GlueTestUtil.createHoodieTable();
    }

    public static void clear() throws IOException {
        fileSystem.delete(new Path(basePath), true);
    }

    public static void teardown() throws IOException {
        fileSystem.close();
    }

    public static HiveSyncConfig getHiveSyncConfig() {
        return hiveSyncConfig;
    }

    public static Configuration getHadoopConf() {
        return hadoopConf;
    }

    public static void createHoodieTable() throws IOException {
        Path path = new Path(basePath);
        if (fileSystem.exists(path)) {
            fileSystem.delete(path, true);
        }
        metaClient = HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.COPY_ON_WRITE).setTableName(TABLE_NAME).setPayloadClass(HoodieAvroPayload.class).initTable(HadoopFSUtils.getStorageConf((Configuration)new Configuration()), basePath);
        String instantTime = "101";
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata(false);
        GlueTestUtil.createMetaFile(basePath, new DefaultInstantFileNameGenerator().makeCommitFileName(instantTime), commitMetadata);
    }

    public static MessageType getSimpleSchema() {
        return MessageTypeParser.parseMessageType((String)"message example_schema {  required int32 id;  required binary name (UTF8);}");
    }

    private static void createMetaFile(String basePath, String fileName, HoodieCommitMetadata metadata) throws IOException {
        byte[] bytes = metadata.toJsonString().getBytes(StandardCharsets.UTF_8);
        Path fullPath = new Path(basePath + "/" + ".hoodie" + "/" + fileName);
        FSDataOutputStream fsout = fileSystem.create(fullPath, true);
        fsout.write(bytes);
        fsout.close();
    }

    public static Column getColumn(String name, String type, String comment) {
        return (Column)Column.builder().name(name).type(type).comment(comment).build();
    }

    public static HoodieTableMetaClient getMetaClient() {
        return metaClient;
    }
}

