/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.transaction.integ;

import java.net.URI;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.hudi.aws.transaction.lock.DynamoDBBasedImplicitPartitionKeyLockProvider;
import org.apache.hudi.aws.transaction.lock.DynamoDBBasedLockProvider;
import org.apache.hudi.aws.transaction.lock.DynamoDBBasedLockProviderBase;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.hash.HashID;
import org.apache.hudi.config.DynamoDbBasedLockConfig;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;

@Disabled(value="HUDI-7475 The tests do not work. Disabling them to unblock Azure CI")
public class ITTestDynamoDBBasedLockProvider {
    private static final LockConfiguration LOCK_CONFIGURATION;
    private static final LockConfiguration IMPLICIT_PART_KEY_LOCK_CONFIG_NO_BASE_PATH;
    private static final LockConfiguration IMPLICIT_PART_KEY_LOCK_CONFIG_WITH_PART_KEY;
    private static final LockConfiguration IMPLICIT_PART_KEY_LOCK_CONFIG_NO_TBL_NAME;
    private static final LockConfiguration IMPLICIT_PART_KEY_LOCK_CONFIG;
    private static final String TABLE_NAME_PREFIX = "testDDBTable-";
    private static final String REGION = "us-east-2";
    private static DynamoDbClient dynamoDb;
    private static String SCHEME_S3;
    private static String SCHEME_S3A;
    private static String URI_NO_CLOUD_PROVIDER_PREFIX;

    @BeforeAll
    public static void setup() throws InterruptedException {
        dynamoDb = ITTestDynamoDBBasedLockProvider.getDynamoClientWithLocalEndpoint();
    }

    public static Stream<Object> badTestDimensions() {
        return Stream.of(Arguments.of((Object[])new Object[]{IMPLICIT_PART_KEY_LOCK_CONFIG_NO_TBL_NAME, DynamoDBBasedLockProvider.class}), Arguments.of((Object[])new Object[]{IMPLICIT_PART_KEY_LOCK_CONFIG_NO_TBL_NAME, DynamoDBBasedImplicitPartitionKeyLockProvider.class}), Arguments.of((Object[])new Object[]{IMPLICIT_PART_KEY_LOCK_CONFIG_NO_BASE_PATH, DynamoDBBasedImplicitPartitionKeyLockProvider.class}));
    }

    private static DynamoDbClient getDynamoClientWithLocalEndpoint() {
        String endpoint = System.getProperty("dynamodb-local.endpoint");
        if (endpoint == null || endpoint.isEmpty()) {
            throw new IllegalStateException("dynamodb-local.endpoint system property not set");
        }
        return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().region(Region.of((String)REGION))).endpointOverride(URI.create(endpoint))).credentialsProvider(ITTestDynamoDBBasedLockProvider.getCredentials())).build();
    }

    private static AwsCredentialsProvider getCredentials() {
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"random-access-key", (String)"random-secret-key"));
    }

    @ParameterizedTest
    @MethodSource(value={"badTestDimensions"})
    void testBadConfig(LockConfiguration lockConfig, Class<?> lockProviderClass) {
        lockConfig.getConfig().setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_NAME.key(), TABLE_NAME_PREFIX + UUID.randomUUID());
        Exception e = new Exception();
        try {
            ReflectionUtils.loadClass((String)lockProviderClass.getName(), (Class[])new Class[]{LockConfiguration.class, StorageConfiguration.class, DynamoDbClient.class}, (Object[])new Object[]{lockConfig, null, dynamoDb});
        }
        catch (Exception ex) {
            e = ex;
        }
        Assertions.assertEquals(IllegalArgumentException.class, e.getCause().getCause().getClass());
    }

    public static Stream<Arguments> testDimensions() {
        return Stream.of(Arguments.of((Object[])new Object[]{IMPLICIT_PART_KEY_LOCK_CONFIG, DynamoDBBasedLockProvider.class}), Arguments.of((Object[])new Object[]{LOCK_CONFIGURATION, DynamoDBBasedLockProvider.class}), Arguments.of((Object[])new Object[]{IMPLICIT_PART_KEY_LOCK_CONFIG_WITH_PART_KEY, DynamoDBBasedImplicitPartitionKeyLockProvider.class}), Arguments.of((Object[])new Object[]{IMPLICIT_PART_KEY_LOCK_CONFIG, DynamoDBBasedImplicitPartitionKeyLockProvider.class}));
    }

    @ParameterizedTest
    @MethodSource(value={"testDimensions"})
    void testAcquireLock(LockConfiguration lockConfig, Class<?> lockProviderClass) {
        lockConfig.getConfig().setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_NAME.key(), TABLE_NAME_PREFIX + UUID.randomUUID());
        DynamoDBBasedLockProviderBase dynamoDbBasedLockProvider = (DynamoDBBasedLockProviderBase)ReflectionUtils.loadClass((String)lockProviderClass.getName(), (Class[])new Class[]{LockConfiguration.class, StorageConfiguration.class, DynamoDbClient.class}, (Object[])new Object[]{lockConfig, null, dynamoDb});
        if (lockProviderClass.equals(DynamoDBBasedLockProvider.class)) {
            String tableName = (String)lockConfig.getConfig().get((Object)"hoodie.table.name");
            String partitionKey = (String)lockConfig.getConfig().get((Object)DynamoDbBasedLockConfig.DYNAMODB_LOCK_PARTITION_KEY.key());
            if (partitionKey != null) {
                Assertions.assertEquals((Object)partitionKey, (Object)dynamoDbBasedLockProvider.getPartitionKey());
            } else {
                Assertions.assertEquals((Object)tableName, (Object)dynamoDbBasedLockProvider.getPartitionKey());
            }
        } else if (lockProviderClass.equals(DynamoDBBasedImplicitPartitionKeyLockProvider.class)) {
            String tableName = (String)lockConfig.getConfig().get((Object)"hoodie.table.name");
            String basePath = (String)lockConfig.getConfig().get((Object)HoodieCommonConfig.BASE_PATH.key());
            Assertions.assertTrue((boolean)basePath.startsWith(SCHEME_S3A));
            Assertions.assertEquals((Object)HashID.generateXXHashAsString((String)(SCHEME_S3 + URI_NO_CLOUD_PROVIDER_PREFIX), (HashID.Size)HashID.Size.BITS_64), (Object)dynamoDbBasedLockProvider.getPartitionKey());
        }
        Assertions.assertTrue((boolean)dynamoDbBasedLockProvider.tryLock(lockConfig.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        dynamoDbBasedLockProvider.unlock();
    }

    @ParameterizedTest
    @MethodSource(value={"testDimensions"})
    void testUnlock(LockConfiguration lockConfig, Class<?> lockProviderClass) {
        lockConfig.getConfig().setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_NAME.key(), TABLE_NAME_PREFIX + UUID.randomUUID());
        DynamoDBBasedLockProviderBase dynamoDbBasedLockProvider = (DynamoDBBasedLockProviderBase)ReflectionUtils.loadClass((String)lockProviderClass.getName(), (Class[])new Class[]{LockConfiguration.class, StorageConfiguration.class, DynamoDbClient.class}, (Object[])new Object[]{lockConfig, null, dynamoDb});
        Assertions.assertTrue((boolean)dynamoDbBasedLockProvider.tryLock(lockConfig.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        dynamoDbBasedLockProvider.unlock();
        Assertions.assertTrue((boolean)dynamoDbBasedLockProvider.tryLock(lockConfig.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
    }

    @ParameterizedTest
    @MethodSource(value={"testDimensions"})
    void testReentrantLock(LockConfiguration lockConfig, Class<?> lockProviderClass) {
        lockConfig.getConfig().setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_NAME.key(), TABLE_NAME_PREFIX + UUID.randomUUID());
        DynamoDBBasedLockProviderBase dynamoDbBasedLockProvider = (DynamoDBBasedLockProviderBase)ReflectionUtils.loadClass((String)lockProviderClass.getName(), (Class[])new Class[]{LockConfiguration.class, StorageConfiguration.class, DynamoDbClient.class}, (Object[])new Object[]{lockConfig, null, dynamoDb});
        Assertions.assertTrue((boolean)dynamoDbBasedLockProvider.tryLock(lockConfig.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)dynamoDbBasedLockProvider.tryLock(lockConfig.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        dynamoDbBasedLockProvider.unlock();
    }

    @ParameterizedTest
    @MethodSource(value={"testDimensions"})
    void testUnlockWithoutLock(LockConfiguration lockConfig, Class<?> lockProviderClass) {
        lockConfig.getConfig().setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_NAME.key(), TABLE_NAME_PREFIX + UUID.randomUUID());
        DynamoDBBasedLockProviderBase dynamoDbBasedLockProvider = (DynamoDBBasedLockProviderBase)ReflectionUtils.loadClass((String)lockProviderClass.getName(), (Class[])new Class[]{LockConfiguration.class, StorageConfiguration.class, DynamoDbClient.class}, (Object[])new Object[]{lockConfig, null, dynamoDb});
        dynamoDbBasedLockProvider.unlock();
    }

    static {
        SCHEME_S3 = "s3";
        SCHEME_S3A = "s3a";
        URI_NO_CLOUD_PROVIDER_PREFIX = "://my-bucket-8b2a4b30/1718662238400/be715573/my_lake/my_table";
        Properties dynamoDblpProps = new Properties();
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_BILLING_MODE.key(), BillingMode.PAY_PER_REQUEST.name());
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_CREATION_TIMEOUT.key(), Integer.toString(100000));
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_REGION.key(), REGION);
        dynamoDblpProps.setProperty("hoodie.write.lock.wait_time_ms", "1000");
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_READ_CAPACITY.key(), "0");
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_WRITE_CAPACITY.key(), "0");
        TypedProperties implicitPartKeyLpProps = TypedProperties.copy((Properties)dynamoDblpProps);
        dynamoDblpProps = TypedProperties.copy((Properties)dynamoDblpProps);
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_PARTITION_KEY.key(), "testKey");
        LOCK_CONFIGURATION = new LockConfiguration(dynamoDblpProps);
        implicitPartKeyLpProps.setProperty(HoodieCommonConfig.BASE_PATH.key(), SCHEME_S3A + URI_NO_CLOUD_PROVIDER_PREFIX);
        implicitPartKeyLpProps.setProperty("hoodie.table.name", "ma_po_tofu_is_awesome");
        IMPLICIT_PART_KEY_LOCK_CONFIG = new LockConfiguration((Properties)implicitPartKeyLpProps);
        TypedProperties withPartKey = TypedProperties.copy((Properties)implicitPartKeyLpProps);
        withPartKey.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_PARTITION_KEY.key(), "testKey");
        IMPLICIT_PART_KEY_LOCK_CONFIG_WITH_PART_KEY = new LockConfiguration((Properties)withPartKey);
        TypedProperties missingBasePath = TypedProperties.copy((Properties)implicitPartKeyLpProps);
        missingBasePath.remove((Object)HoodieCommonConfig.BASE_PATH.key());
        IMPLICIT_PART_KEY_LOCK_CONFIG_NO_BASE_PATH = new LockConfiguration((Properties)missingBasePath);
        TypedProperties missingTableName = TypedProperties.copy((Properties)implicitPartKeyLpProps);
        missingTableName.remove((Object)"hoodie.table.name");
        IMPLICIT_PART_KEY_LOCK_CONFIG_NO_TBL_NAME = new LockConfiguration((Properties)missingTableName);
    }
}

