/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.transaction.lock;

import java.util.Properties;
import org.apache.hudi.aws.transaction.lock.DynamoDBBasedLockProvider;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.config.DynamoDbBasedLockConfig;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;

class DynamoDBBasedLockProviderBaseTest {
    private static final LockConfiguration LOCK_CONFIGURATION;
    @Mock
    private static DynamoDbClient mockClient;

    DynamoDBBasedLockProviderBaseTest() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testLockProviderBaseInitialization(boolean isNull) {
        Exception e = null;
        try {
            new DynamoDBBasedLockProvider(LOCK_CONFIGURATION, (StorageConfiguration)new HadoopStorageConfiguration(Boolean.valueOf(true)), isNull ? null : mockClient);
        }
        catch (Exception ex) {
            e = ex;
        }
        Assertions.assertNotNull((Object)e);
        if (isNull) {
            Assertions.assertEquals(SdkClientException.class, e.getClass());
        } else {
            Assertions.assertNotEquals(NullPointerException.class, e.getClass());
        }
    }

    static {
        mockClient = new DynamoDbClient(){

            public String serviceName() {
                return "";
            }

            public void close() {
            }
        };
        TypedProperties dynamoDblpProps = new TypedProperties();
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_BILLING_MODE.key(), BillingMode.PAY_PER_REQUEST.name());
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_CREATION_TIMEOUT.key(), Integer.toString(100000));
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_REGION.key(), "us-east-2");
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_NAME.key(), "my-table");
        dynamoDblpProps.setProperty("hoodie.write.lock.wait_time_ms", "1000");
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_READ_CAPACITY.key(), "0");
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_WRITE_CAPACITY.key(), "0");
        dynamoDblpProps.setProperty(DynamoDbBasedLockConfig.DYNAMODB_LOCK_PARTITION_KEY.key(), "testKey");
        LOCK_CONFIGURATION = new LockConfiguration((Properties)dynamoDblpProps);
    }
}

