/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.transaction.lock;

import java.util.Properties;
import org.apache.hudi.client.transaction.lock.StorageBasedLockProvider;
import org.apache.hudi.client.transaction.lock.StorageBasedLockProviderTestBase;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.config.HoodieAWSConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;

@Disabled(value="HUDI-9159 The tests do not work. Disabling them to unblock Azure CI")
public class TestS3StorageBasedLockProvider
extends StorageBasedLockProviderTestBase {
    private static final DockerImageName LOCALSTACK_IMAGE = DockerImageName.parse((String)"localstack/localstack:4.1.0");
    private static LocalStackContainer S3_CONTAINER;
    private static final String TEST_BUCKET = "test-bucket";
    private static S3Client s3Client;

    @BeforeAll
    static void initContainer() {
        S3_CONTAINER = new LocalStackContainer(LOCALSTACK_IMAGE).withServices(new LocalStackContainer.Service[]{LocalStackContainer.Service.S3});
        S3_CONTAINER.start();
        s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().endpointOverride(S3_CONTAINER.getEndpointOverride(LocalStackContainer.Service.S3))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)S3_CONTAINER.getAccessKey(), (String)S3_CONTAINER.getSecretKey())))).region(Region.of((String)S3_CONTAINER.getRegion()))).build();
        s3Client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(TEST_BUCKET).build());
    }

    @AfterAll
    static void stopContainer() {
        if (S3_CONTAINER != null) {
            S3_CONTAINER.stop();
        }
    }

    protected StorageBasedLockProvider createLockProvider() {
        LockConfiguration lockConf = new LockConfiguration((Properties)providerProperties);
        try (MockedStatic s3ClientStaticMock = Mockito.mockStatic(S3Client.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            s3ClientStaticMock.when(S3Client::builder).thenAnswer(invocation -> {
                S3ClientBuilder builder = (S3ClientBuilder)invocation.callRealMethod();
                builder.endpointOverride(S3_CONTAINER.getEndpointOverride(LocalStackContainer.Service.S3));
                return builder;
            });
            StorageBasedLockProvider storageBasedLockProvider = new StorageBasedLockProvider(lockConf, null);
            return storageBasedLockProvider;
        }
    }

    @BeforeEach
    void setupLockProvider() {
        providerProperties.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)String.format("s3://%s/lake/db/tbl-default", TEST_BUCKET));
        providerProperties.put((Object)HoodieAWSConfig.AWS_SECRET_KEY.key(), (Object)S3_CONTAINER.getSecretKey());
        providerProperties.put((Object)HoodieAWSConfig.AWS_ACCESS_KEY.key(), (Object)S3_CONTAINER.getAccessKey());
        this.lockProvider = this.createLockProvider();
    }

    @Test
    void testS3Preconditions() {
        String key = "my-test-object";
        PutObjectResponse put1 = s3Client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(TEST_BUCKET).key(key).serverSideEncryption(ServerSideEncryption.AES256).ifNoneMatch("*").build(), RequestBody.fromString((String)"Hello1"));
        PutObjectResponse put2 = s3Client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(TEST_BUCKET).key(key).serverSideEncryption(ServerSideEncryption.AES256).ifMatch(put1.eTag()).build(), RequestBody.fromString((String)"Hello2"));
        s3Client.close();
        Assertions.assertNotNull((Object)put1.eTag());
        Assertions.assertNotNull((Object)put2.eTag());
        Assertions.assertNotEquals((Object)put1.eTag(), (Object)put2.eTag(), (String)"ETags should differ if the content changed");
    }
}

