/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.transaction.lock;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.hudi.aws.transaction.lock.S3StorageLockClient;
import org.apache.hudi.client.transaction.lock.models.LockGetResult;
import org.apache.hudi.client.transaction.lock.models.LockUpsertResult;
import org.apache.hudi.client.transaction.lock.models.StorageLockData;
import org.apache.hudi.client.transaction.lock.models.StorageLockFile;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieLockException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;

@ExtendWith(value={MockitoExtension.class})
class TestS3StorageLockClient {
    private static final String OWNER_ID = "ownerId";
    private static final String LOCK_FILE_URI = "s3://bucket/lockFilePath";
    private static final String LOCK_FILE_PATH = "lockFilePath";
    @Mock
    private S3Client mockS3Client;
    @Mock
    private Logger mockLogger;
    private S3StorageLockClient lockService;

    TestS3StorageLockClient() {
    }

    @BeforeEach
    void setUp() {
        this.lockService = new S3StorageLockClient(OWNER_ID, LOCK_FILE_URI, new Properties(), (Functions.Function2 & Serializable)(a, b) -> this.mockS3Client, this.mockLogger);
    }

    private void mockS3ObjectWithLockData(StorageLockData lockData, String eTag) {
        byte[] bytes = StorageLockFile.toByteArray((StorageLockData)lockData);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ResponseInputStream mockResponseStream = new ResponseInputStream(GetObjectResponse.builder().eTag(eTag).build(), (InputStream)new MockAbortableInputStream(bais));
        Mockito.when((Object)this.mockS3Client.getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class))).thenReturn((Object)mockResponseStream);
    }

    @Test
    void testTryCreateOrUpdateLockFile_noPreviousLock_success() {
        StorageLockData lockData = new StorageLockData(false, System.currentTimeMillis(), "myTxOwner");
        PutObjectResponse putResp = (PutObjectResponse)PutObjectResponse.builder().eTag("new-etag-123").build();
        Mockito.when((Object)this.mockS3Client.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class), (RequestBody)ArgumentMatchers.any(RequestBody.class))).thenReturn((Object)putResp);
        Pair result = this.lockService.tryUpsertLockFile(lockData, Option.empty());
        Assertions.assertEquals((Object)LockUpsertResult.SUCCESS, (Object)result.getLeft());
        Assertions.assertTrue((boolean)((Option)result.getRight()).isPresent());
        Assertions.assertEquals((Object)"new-etag-123", (Object)((StorageLockFile)((Option)result.getRight()).get()).getVersionId());
        ((S3Client)Mockito.verify((Object)this.mockS3Client, (VerificationMode)Mockito.times((int)1))).putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class), (RequestBody)ArgumentMatchers.any(RequestBody.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger});
    }

    @Test
    void testInitializeWithInvalidUri() {
        Assertions.assertThrows(HoodieLockException.class, () -> new S3StorageLockClient(OWNER_ID, "\\", new Properties(), (Functions.Function2 & Serializable)(a, b) -> this.mockS3Client, this.mockLogger));
    }

    @Test
    void testInitializeWithNoLockFilePath() {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new S3StorageLockClient(OWNER_ID, "s3://bucket/", new Properties(), (Functions.Function2 & Serializable)(a, b) -> this.mockS3Client, this.mockLogger));
        Assertions.assertTrue((boolean)ex.getMessage().contains("lock file path"));
    }

    @Test
    void testInitializeWithNoBucketName() {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new S3StorageLockClient(OWNER_ID, "s3:///path", new Properties(), (Functions.Function2 & Serializable)(a, b) -> this.mockS3Client, this.mockLogger));
        Assertions.assertTrue((boolean)ex.getMessage().contains("bucket name"));
    }

    @Test
    void testTryCreateOrUpdateLockFile_withPreviousLock_success() {
        StorageLockData lockData = new StorageLockData(false, 1000L, "myTxOwner");
        StorageLockFile prevLockFile = new StorageLockFile(lockData, "old-etag-999");
        PutObjectResponse putResp = (PutObjectResponse)PutObjectResponse.builder().eTag("new-etag-456").build();
        Mockito.when((Object)this.mockS3Client.putObject((PutObjectRequest)ArgumentMatchers.eq((Object)PutObjectRequest.builder().bucket("bucket").key(LOCK_FILE_PATH).ifMatch("old-etag-999").build()), (RequestBody)ArgumentMatchers.any(RequestBody.class))).thenReturn((Object)putResp);
        Pair result = this.lockService.tryUpsertLockFile(lockData, Option.of((Object)prevLockFile));
        Assertions.assertEquals((Object)LockUpsertResult.SUCCESS, (Object)result.getLeft());
        Assertions.assertTrue((boolean)((Option)result.getRight()).isPresent());
        Assertions.assertEquals((Object)"new-etag-456", (Object)((StorageLockFile)((Option)result.getRight()).get()).getVersionId());
        ((S3Client)Mockito.verify((Object)this.mockS3Client, (VerificationMode)Mockito.times((int)1))).putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class), (RequestBody)ArgumentMatchers.any(RequestBody.class));
    }

    @Test
    void testTryCreateOrUpdateLockFile_preconditionFailed() {
        StorageLockData lockData = new StorageLockData(false, 2000L, "txOwner");
        StorageLockFile prevLockFile = new StorageLockFile(lockData, "some-etag");
        AwsServiceException ex412 = S3Exception.builder().statusCode(412).build();
        Mockito.when((Object)this.mockS3Client.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class), (RequestBody)ArgumentMatchers.any(RequestBody.class))).thenThrow(new Throwable[]{ex412});
        Pair result = this.lockService.tryUpsertLockFile(lockData, Option.of((Object)prevLockFile));
        Assertions.assertEquals((Object)LockUpsertResult.ACQUIRED_BY_OTHERS, (Object)result.getLeft());
        Assertions.assertTrue((boolean)((Option)result.getRight()).isEmpty());
        ((Logger)Mockito.verify((Object)this.mockLogger)).warn(ArgumentMatchers.contains((String)"Lockfile modified by another process"), ArgumentMatchers.eq((Object)OWNER_ID), ArgumentMatchers.eq((Object)LOCK_FILE_PATH));
    }

    @Test
    void testTryCreateOrUpdateLockFile_conflict409() {
        StorageLockData lockData = new StorageLockData(false, 3000L, "myTxOwner");
        StorageLockFile prevLockFile = new StorageLockFile(lockData, "some-etag-409");
        AwsServiceException ex409 = S3Exception.builder().statusCode(409).build();
        Mockito.when((Object)this.mockS3Client.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class), (RequestBody)ArgumentMatchers.any(RequestBody.class))).thenThrow(new Throwable[]{ex409});
        Pair result = this.lockService.tryUpsertLockFile(lockData, Option.of((Object)prevLockFile));
        Assertions.assertEquals((Object)LockUpsertResult.UNKNOWN_ERROR, (Object)result.getLeft());
        Assertions.assertTrue((boolean)((Option)result.getRight()).isEmpty());
        ((Logger)Mockito.verify((Object)this.mockLogger)).warn(ArgumentMatchers.contains((String)"Retriable conditional request conflict error"), ArgumentMatchers.eq((Object)OWNER_ID), ArgumentMatchers.eq((Object)LOCK_FILE_PATH));
    }

    @Test
    void testTryCreateOrUpdateLockFile_rateLimitExceeded() {
        StorageLockData lockData = new StorageLockData(false, 4000L, "myTxOwner");
        AwsServiceException ex429 = S3Exception.builder().statusCode(429).build();
        Mockito.when((Object)this.mockS3Client.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class), (RequestBody)ArgumentMatchers.any(RequestBody.class))).thenThrow(new Throwable[]{ex429});
        Pair result = this.lockService.tryUpsertLockFile(lockData, Option.empty());
        Assertions.assertEquals((Object)LockUpsertResult.UNKNOWN_ERROR, (Object)result.getLeft());
        Assertions.assertTrue((boolean)((Option)result.getRight()).isEmpty());
        ((Logger)Mockito.verify((Object)this.mockLogger)).warn(ArgumentMatchers.contains((String)"Rate limit exceeded"), ArgumentMatchers.eq((Object)OWNER_ID), ArgumentMatchers.eq((Object)LOCK_FILE_PATH));
    }

    @Test
    void testTryCreateOrUpdateLockFile_serverError() {
        StorageLockData lockData = new StorageLockData(false, 5000L, "myTxOwner");
        AwsServiceException ex503 = S3Exception.builder().statusCode(503).build();
        Mockito.when((Object)this.mockS3Client.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class), (RequestBody)ArgumentMatchers.any(RequestBody.class))).thenThrow(new Throwable[]{ex503});
        Pair result = this.lockService.tryUpsertLockFile(lockData, Option.empty());
        Assertions.assertEquals((Object)LockUpsertResult.UNKNOWN_ERROR, (Object)result.getLeft());
        Assertions.assertTrue((boolean)((Option)result.getRight()).isEmpty());
        ((Logger)Mockito.verify((Object)this.mockLogger)).warn(ArgumentMatchers.contains((String)"internal server error"), new Object[]{ArgumentMatchers.eq((Object)OWNER_ID), ArgumentMatchers.eq((Object)LOCK_FILE_PATH), ArgumentMatchers.eq((Object)ex503)});
    }

    @Test
    void testTryCreateLockFile_unexpectedError() {
        StorageLockData lockData = new StorageLockData(false, 8000L, "myTxOwner");
        AwsServiceException ex400 = AwsServiceException.builder().statusCode(400).build();
        Mockito.when((Object)this.mockS3Client.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class), (RequestBody)ArgumentMatchers.any(RequestBody.class))).thenThrow(new Throwable[]{ex400});
        Assertions.assertThrows(AwsServiceException.class, () -> this.lockService.tryUpsertLockFile(lockData, Option.empty()));
    }

    @Test
    void testGetCurrentLockFile_404Error() {
        AwsServiceException ex404 = S3Exception.builder().statusCode(404).build();
        Mockito.when((Object)this.mockS3Client.getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class))).thenThrow(new Throwable[]{ex404});
        Pair result = this.lockService.readCurrentLockFile();
        Assertions.assertEquals((Object)LockGetResult.NOT_EXISTS, (Object)result.getLeft());
        Assertions.assertTrue((boolean)((Option)result.getRight()).isEmpty());
        ((Logger)Mockito.verify((Object)this.mockLogger)).info(ArgumentMatchers.contains((String)"Object not found"), ArgumentMatchers.eq((Object)OWNER_ID), ArgumentMatchers.eq((Object)LOCK_FILE_PATH));
    }

    @Test
    void testGetCurrentLockFile_409Error() {
        AwsServiceException ex409 = S3Exception.builder().statusCode(409).build();
        Mockito.when((Object)this.mockS3Client.getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class))).thenThrow(new Throwable[]{ex409});
        Pair result = this.lockService.readCurrentLockFile();
        Assertions.assertEquals((Object)LockGetResult.UNKNOWN_ERROR, (Object)result.getLeft());
        Assertions.assertTrue((boolean)((Option)result.getRight()).isEmpty());
        ((Logger)Mockito.verify((Object)this.mockLogger)).info(ArgumentMatchers.contains((String)"Conflicting operation has occurred"), ArgumentMatchers.eq((Object)OWNER_ID), ArgumentMatchers.eq((Object)LOCK_FILE_PATH));
    }

    @Test
    void testGetCurrentLockFile_objectFound() {
        StorageLockData lockData = new StorageLockData(false, 9999L, "myTxOwner");
        this.mockS3ObjectWithLockData(lockData, "abc-etag");
        Pair result = this.lockService.readCurrentLockFile();
        Assertions.assertEquals((Object)LockGetResult.SUCCESS, (Object)result.getLeft());
        Assertions.assertTrue((boolean)((Option)result.getRight()).isPresent());
        Assertions.assertEquals((Object)"abc-etag", (Object)((StorageLockFile)((Option)result.getRight()).get()).getVersionId());
        Assertions.assertEquals((Object)"myTxOwner", (Object)((StorageLockFile)((Option)result.getRight()).get()).getOwner());
    }

    @Test
    void testGetCurrentLockFile_rateLimit() {
        AwsServiceException ex429 = S3Exception.builder().statusCode(429).build();
        Mockito.when((Object)this.mockS3Client.getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class))).thenThrow(new Throwable[]{ex429});
        Pair result = this.lockService.readCurrentLockFile();
        Assertions.assertEquals((Object)LockGetResult.UNKNOWN_ERROR, (Object)result.getLeft());
        Assertions.assertTrue((boolean)((Option)result.getRight()).isEmpty());
        ((Logger)Mockito.verify((Object)this.mockLogger)).warn(ArgumentMatchers.contains((String)"Rate limit exceeded"), ArgumentMatchers.eq((Object)OWNER_ID), ArgumentMatchers.eq((Object)LOCK_FILE_PATH));
    }

    @Test
    void testGetCurrentLockFile_serverError() {
        AwsServiceException ex500 = S3Exception.builder().statusCode(500).build();
        Mockito.when((Object)this.mockS3Client.getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class))).thenThrow(new Throwable[]{ex500});
        Pair result = this.lockService.readCurrentLockFile();
        Assertions.assertEquals((Object)LockGetResult.UNKNOWN_ERROR, (Object)result.getLeft());
        Assertions.assertTrue((boolean)((Option)result.getRight()).isEmpty());
        ((Logger)Mockito.verify((Object)this.mockLogger)).warn(ArgumentMatchers.contains((String)"S3 internal server error"), new Object[]{ArgumentMatchers.eq((Object)OWNER_ID), ArgumentMatchers.eq((Object)LOCK_FILE_PATH), ArgumentMatchers.eq((Object)ex500)});
    }

    @Test
    void testGetCurrentLockFile_unexpectedError() {
        AwsServiceException ex400 = S3Exception.builder().statusCode(400).build();
        Mockito.when((Object)this.mockS3Client.getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class))).thenThrow(new Throwable[]{ex400});
        Assertions.assertThrows(S3Exception.class, () -> this.lockService.readCurrentLockFile());
    }

    @Test
    void testGetCurrentLockFile_readFailure() {
        GetObjectResponse getObjectResponse = (GetObjectResponse)GetObjectResponse.builder().eTag("some-etag").build();
        ResponseInputStream mockStream = (ResponseInputStream)Mockito.mock(ResponseInputStream.class);
        Mockito.when((Object)mockStream.response()).thenReturn((Object)getObjectResponse);
        try {
            Mockito.when((Object)mockStream.read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{new IOException("Read error")});
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Mockito.when((Object)this.mockS3Client.getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class))).thenReturn((Object)mockStream);
        Assertions.assertThrows(HoodieIOException.class, () -> this.lockService.readCurrentLockFile());
    }

    @Test
    void testClose() throws Exception {
        this.lockService.close();
        ((S3Client)Mockito.verify((Object)this.mockS3Client)).close();
    }

    private static class MockAbortableInputStream
    extends FilterInputStream {
        protected MockAbortableInputStream(ByteArrayInputStream in) {
            super(in);
        }
    }
}

