/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.HoodieTableHeaderFields;
import org.apache.hudi.cli.utils.CommitUtil;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.NumericUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class DiffCommand {
    private static final BiFunction<HoodieWriteStat, String, Boolean> FILE_ID_CHECKER = (writeStat, fileId) -> fileId.equals(writeStat.getFileId());
    private static final BiFunction<HoodieWriteStat, String, Boolean> PARTITION_CHECKER = (writeStat, partitionPath) -> partitionPath.equals(writeStat.getPartitionPath());

    @ShellMethod(key={"diff file"}, value="Check how file differs across range of commits")
    public String diffFile(@ShellOption(value={"--fileId"}, help="File ID to diff across range of commits") String fileId, @ShellOption(value={"--startTs"}, help="start time for compactions, default: now - 10 days", defaultValue="__NULL__") String startTs, @ShellOption(value={"--endTs"}, help="end time for compactions, default: now - 1 day", defaultValue="__NULL__") String endTs, @ShellOption(value={"--limit"}, help="Limit compactions", defaultValue="-1") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--includeArchivedTimeline"}, help="Include archived commits as well", defaultValue="false") boolean includeArchivedTimeline) throws IOException {
        HoodieDefaultTimeline timeline = this.getTimelineInRange(startTs, endTs, includeArchivedTimeline);
        return this.printCommitsWithMetadataForFileId(timeline, limit, sortByField, descending, headerOnly, "", fileId);
    }

    @ShellMethod(key={"diff partition"}, value="Check how file differs across range of commits. It is meant to be used only for partitioned tables.")
    public String diffPartition(@ShellOption(value={"--partitionPath"}, help="Relative partition path to diff across range of commits") String partitionPath, @ShellOption(value={"--startTs"}, help="start time for compactions, default: now - 10 days", defaultValue="__NULL__") String startTs, @ShellOption(value={"--endTs"}, help="end time for compactions, default: now - 1 day", defaultValue="__NULL__") String endTs, @ShellOption(value={"--limit"}, help="Limit compactions", defaultValue="-1") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--includeArchivedTimeline"}, help="Include archived commits as well", defaultValue="false") boolean includeArchivedTimeline) throws IOException {
        HoodieDefaultTimeline timeline = this.getTimelineInRange(startTs, endTs, includeArchivedTimeline);
        return this.printCommitsWithMetadataForPartition(timeline, limit, sortByField, descending, headerOnly, "", partitionPath);
    }

    private HoodieDefaultTimeline getTimelineInRange(String startTs, String endTs, boolean includeArchivedTimeline) {
        if (StringUtils.isNullOrEmpty((String)startTs)) {
            startTs = CommitUtil.getTimeDaysAgo(10);
        }
        if (StringUtils.isNullOrEmpty((String)endTs)) {
            endTs = CommitUtil.getTimeDaysAgo(1);
        }
        ValidationUtils.checkArgument((boolean)StringUtils.nonEmpty((String)startTs), (String)"startTs is null or empty");
        ValidationUtils.checkArgument((boolean)StringUtils.nonEmpty((String)endTs), (String)"endTs is null or empty");
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        if (includeArchivedTimeline) {
            HoodieArchivedTimeline archivedTimeline = metaClient.getArchivedTimeline();
            archivedTimeline.loadInstantDetailsInMemory(startTs, endTs);
            return archivedTimeline.findInstantsInRange(startTs, endTs).mergeTimeline((HoodieDefaultTimeline)activeTimeline);
        }
        return activeTimeline;
    }

    private String printCommitsWithMetadataForFileId(HoodieDefaultTimeline timeline, Integer limit, String sortByField, boolean descending, boolean headerOnly, String tempTableName, String fileId) throws IOException {
        return this.printDiffWithMetadata(timeline, limit, sortByField, descending, headerOnly, tempTableName, fileId, FILE_ID_CHECKER);
    }

    private String printCommitsWithMetadataForPartition(HoodieDefaultTimeline timeline, Integer limit, String sortByField, boolean descending, boolean headerOnly, String tempTableName, String partition) throws IOException {
        return this.printDiffWithMetadata(timeline, limit, sortByField, descending, headerOnly, tempTableName, partition, PARTITION_CHECKER);
    }

    private String printDiffWithMetadata(HoodieDefaultTimeline timeline, Integer limit, String sortByField, boolean descending, boolean headerOnly, String tempTableName, String diffEntity, BiFunction<HoodieWriteStat, String, Boolean> diffEntityChecker) throws IOException {
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        List commits = timeline.getCommitsTimeline().filterCompletedInstants().getInstants().sorted(HoodieInstant.COMPARATOR.reversed()).collect(Collectors.toList());
        for (HoodieInstant commit : commits) {
            Option instantDetails = timeline.getInstantDetails(commit);
            if (!instantDetails.isPresent()) continue;
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])instantDetails.get()), HoodieCommitMetadata.class);
            for (Map.Entry partitionWriteStat : commitMetadata.getPartitionToWriteStats().entrySet()) {
                for (HoodieWriteStat hoodieWriteStat : (List)partitionWriteStat.getValue()) {
                    this.populateRows(rows, commit, hoodieWriteStat, diffEntity, diffEntityChecker);
                }
            }
        }
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Bytes Written", entry -> NumericUtils.humanReadableByteCount((double)Double.parseDouble(entry.toString())));
        return HoodiePrintHelper.print(HoodieTableHeaderFields.getTableHeaderWithExtraMetadata(), fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows, tempTableName);
    }

    private void populateRows(List<Comparable[]> rows, HoodieInstant commit, HoodieWriteStat hoodieWriteStat, String value, BiFunction<HoodieWriteStat, String, Boolean> checker) {
        if (checker.apply(hoodieWriteStat, value).booleanValue()) {
            rows.add(new Comparable[]{commit.getAction(), commit.getTimestamp(), hoodieWriteStat.getPartitionPath(), hoodieWriteStat.getFileId(), hoodieWriteStat.getPrevCommit(), Long.valueOf(hoodieWriteStat.getNumWrites()), Long.valueOf(hoodieWriteStat.getNumInserts()), Long.valueOf(hoodieWriteStat.getNumDeletes()), Long.valueOf(hoodieWriteStat.getNumUpdateWrites()), Long.valueOf(hoodieWriteStat.getTotalWriteErrors()), Long.valueOf(hoodieWriteStat.getTotalLogBlocks()), Long.valueOf(hoodieWriteStat.getTotalCorruptLogBlock()), Long.valueOf(hoodieWriteStat.getTotalRollbackBlocks()), Long.valueOf(hoodieWriteStat.getTotalLogRecords()), Long.valueOf(hoodieWriteStat.getTotalUpdatedRecordsCompacted()), Long.valueOf(hoodieWriteStat.getTotalWriteBytes())});
        }
    }
}

