/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieEngineContext;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class SavepointsCommand
implements CommandMarker {
    @CliCommand(value={"savepoints show"}, help="Show the savepoints")
    public String showSavepoints() {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getSavePointTimeline().filterCompletedInstants();
        List commits = timeline.getReverseOrderedInstants().collect(Collectors.toList());
        String[][] rows = new String[commits.size()][];
        for (int i = 0; i < commits.size(); ++i) {
            HoodieInstant commit = (HoodieInstant)commits.get(i);
            rows[i] = new String[]{commit.getTimestamp()};
        }
        return HoodiePrintHelper.print(new String[]{"SavepointTime"}, rows);
    }

    @CliCommand(value={"savepoint create"}, help="Savepoint a commit")
    public String savepoint(@CliOption(key={"commit"}, help="Commit to savepoint") String commitTime, @CliOption(key={"user"}, unspecifiedDefaultValue="default", help="User who is creating the savepoint") String user, @CliOption(key={"comments"}, unspecifiedDefaultValue="default", help="Comments for creating the savepoint") String comments, @CliOption(key={"sparkProperties"}, help="Spark Properties File Path") String sparkPropertiesPath, @CliOption(key={"sparkMaster"}, unspecifiedDefaultValue="", help="Spark Master") String master, @CliOption(key={"sparkMemory"}, unspecifiedDefaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieInstant commitInstant;
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitTimeline().filterCompletedInstants();
        if (!timeline.containsInstant(commitInstant = new HoodieInstant(false, "commit", commitTime))) {
            return "Commit " + commitTime + " not found in Commits " + timeline;
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.SAVEPOINT.toString(), master, sparkMemory, commitTime, user, comments, metaClient.getBasePath()});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not create savepoint \"%s\".", commitTime);
        }
        return String.format("The commit \"%s\" has been savepointed.", commitTime);
    }

    @CliCommand(value={"savepoint rollback"}, help="Savepoint a commit")
    public String rollbackToSavepoint(@CliOption(key={"savepoint"}, help="Savepoint to rollback") String instantTime, @CliOption(key={"sparkProperties"}, help="Spark Properties File Path") String sparkPropertiesPath, @CliOption(key={"sparkMaster"}, unspecifiedDefaultValue="", help="Spark Master") String master, @CliOption(key={"sparkMemory"}, unspecifiedDefaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieInstant commitInstant;
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        if (metaClient.getActiveTimeline().getSavePointTimeline().filterCompletedInstants().empty()) {
            throw new HoodieException("There are no completed instants to run rollback");
        }
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitTimeline().filterCompletedInstants();
        if (!timeline.containsInstant(commitInstant = new HoodieInstant(false, "commit", instantTime))) {
            return "Commit " + instantTime + " not found in Commits " + timeline;
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.ROLLBACK_TO_SAVEPOINT.toString(), master, sparkMemory, instantTime, metaClient.getBasePath()});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Savepoint \"%s\" failed to roll back", instantTime);
        }
        return String.format("Savepoint \"%s\" rolled back", instantTime);
    }

    @CliCommand(value={"savepoint delete"}, help="Delete the savepoint")
    public String deleteSavepoint(@CliOption(key={"commit"}, help="Delete a savepoint") String instantTime, @CliOption(key={"sparkProperties"}, help="Spark Properties File Path") String sparkPropertiesPath, @CliOption(key={"sparkMaster"}, unspecifiedDefaultValue="", help="Spark Master") String master, @CliOption(key={"sparkMemory"}, unspecifiedDefaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        HoodieTimeline completedInstants = metaClient.getActiveTimeline().getSavePointTimeline().filterCompletedInstants();
        if (completedInstants.empty()) {
            throw new HoodieException("There are no completed savepoint to run delete");
        }
        HoodieInstant savePoint = new HoodieInstant(false, "savepoint", instantTime);
        if (!completedInstants.containsInstant(savePoint)) {
            return "Commit " + instantTime + " not found in Commits " + completedInstants;
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.DELETE_SAVEPOINT.toString(), master, sparkMemory, instantTime, metaClient.getBasePath()});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not delete savepoint \"%s\".", instantTime);
        }
        return String.format("Savepoint \"%s\" deleted.", instantTime);
    }

    private static SparkRDDWriteClient createHoodieClient(JavaSparkContext jsc, String basePath) throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(basePath).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).build();
        return new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(jsc), config, false);
    }
}

