/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.NumericUtils;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class StatsCommand
implements CommandMarker {
    public static final int MAX_FILES = 1000000;

    @CliCommand(value={"stats wa"}, help="Write Amplification. Ratio of how many records were upserted to how many records were actually written")
    public String writeAmplificationStats(@CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        long totalRecordsUpserted = 0L;
        long totalRecordsWritten = 0L;
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitTimeline().filterCompletedInstants();
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        DecimalFormat df = new DecimalFormat("#.00");
        for (HoodieInstant instantTime : timeline.getInstants().collect(Collectors.toList())) {
            String waf = "0";
            HoodieCommitMetadata commit = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])activeTimeline.getInstantDetails(instantTime).get()), HoodieCommitMetadata.class);
            if (commit.fetchTotalUpdateRecordsWritten() > 0L) {
                waf = df.format((float)commit.fetchTotalRecordsWritten() / (float)commit.fetchTotalUpdateRecordsWritten());
            }
            rows.add(new Comparable[]{instantTime.getTimestamp(), Long.valueOf(commit.fetchTotalUpdateRecordsWritten()), Long.valueOf(commit.fetchTotalRecordsWritten()), waf});
            totalRecordsUpserted += commit.fetchTotalUpdateRecordsWritten();
            totalRecordsWritten += commit.fetchTotalRecordsWritten();
        }
        String waf = "0";
        if (totalRecordsUpserted > 0L) {
            waf = df.format((float)totalRecordsWritten / (float)totalRecordsUpserted);
        }
        rows.add(new Comparable[]{"Total", Long.valueOf(totalRecordsUpserted), Long.valueOf(totalRecordsWritten), waf});
        TableHeader header = new TableHeader().addTableHeaderField("CommitTime").addTableHeaderField("Total Upserted").addTableHeaderField("Total Written").addTableHeaderField("Write Amplification Factor");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    public Comparable[] printFileSizeHistogram(String instantTime, Snapshot s) {
        return new Comparable[]{instantTime, Long.valueOf(s.getMin()), Double.valueOf(s.getValue(0.1)), Double.valueOf(s.getMedian()), Double.valueOf(s.getMean()), Double.valueOf(s.get95thPercentile()), Long.valueOf(s.getMax()), Integer.valueOf(s.size()), Double.valueOf(s.getStdDev())};
    }

    @CliCommand(value={"stats filesizes"}, help="File Sizes. Display summary stats on sizes of files")
    public String fileSizeStats(@CliOption(key={"partitionPath"}, help="regex to select files, eg: 2016/08/02", unspecifiedDefaultValue="*/*/*") String globRegex, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        FileSystem fs = HoodieCLI.fs;
        String globPath = String.format("%s/%s/*", HoodieCLI.getTableMetaClient().getBasePath(), globRegex);
        List statuses = FSUtils.getGlobStatusExcludingMetaFolder((FileSystem)fs, (Path)new Path(globPath));
        Histogram globalHistogram = new Histogram((Reservoir)new UniformReservoir(1000000));
        HashMap<String, Histogram> commitHistoMap = new HashMap<String, Histogram>();
        for (Object fileStatus : statuses) {
            String string = FSUtils.getCommitTime((String)fileStatus.getPath().getName());
            long sz = fileStatus.getLen();
            if (!commitHistoMap.containsKey(string)) {
                commitHistoMap.put(string, new Histogram((Reservoir)new UniformReservoir(1000000)));
            }
            ((Histogram)commitHistoMap.get(string)).update(sz);
            globalHistogram.update(sz);
        }
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (Map.Entry entry : commitHistoMap.entrySet()) {
            Snapshot s = ((Histogram)entry.getValue()).getSnapshot();
            rows.add(this.printFileSizeHistogram((String)entry.getKey(), s));
        }
        Snapshot s = globalHistogram.getSnapshot();
        rows.add(this.printFileSizeHistogram("ALL", s));
        TableHeader tableHeader = new TableHeader().addTableHeaderField("CommitTime").addTableHeaderField("Min").addTableHeaderField("10th").addTableHeaderField("50th").addTableHeaderField("avg").addTableHeaderField("95th").addTableHeaderField("Max").addTableHeaderField("NumFiles").addTableHeaderField("StdDev");
        return HoodiePrintHelper.print(tableHeader, this.getFieldNameToConverterMap(), sortByField, descending, limit, headerOnly, rows);
    }

    public Map<String, Function<Object, String>> getFieldNameToConverterMap() {
        Function<Object, String> converterFunction = entry -> NumericUtils.humanReadableByteCount((double)Double.parseDouble(entry.toString()));
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Min", converterFunction);
        fieldNameToConverterMap.put("10th", converterFunction);
        fieldNameToConverterMap.put("50th", converterFunction);
        fieldNameToConverterMap.put("avg", converterFunction);
        fieldNameToConverterMap.put("95th", converterFunction);
        fieldNameToConverterMap.put("Max", converterFunction);
        fieldNameToConverterMap.put("StdDev", converterFunction);
        return fieldNameToConverterMap;
    }
}

