/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.util.Option;

public class Table
implements Iterable<List<String>> {
    private final TableHeader rowHeader;
    private final Map<String, Function<Object, String>> fieldNameToConverterMap;
    private final Option<String> orderingFieldNameOptional;
    private final Option<Boolean> isDescendingOptional;
    private final Option<Integer> limitOptional;
    private final List<List<Comparable>> rawRows;
    private boolean finishedAdding = false;
    private List<List<String>> renderRows;

    public Table(TableHeader rowHeader, Map<String, Function<Object, String>> fieldNameToConverterMap, Option<String> orderingFieldNameOptional, Option<Boolean> isDescendingOptional, Option<Integer> limitOptional) {
        this.rowHeader = rowHeader;
        this.fieldNameToConverterMap = fieldNameToConverterMap;
        this.orderingFieldNameOptional = orderingFieldNameOptional;
        this.isDescendingOptional = isDescendingOptional;
        this.limitOptional = limitOptional;
        this.rawRows = new ArrayList<List<Comparable>>();
    }

    public Table add(List<Comparable> row) {
        if (this.finishedAdding) {
            throw new IllegalStateException("Container already marked done for adding. No more entries can be added.");
        }
        if (this.rowHeader.getFieldNames().size() != row.size()) {
            throw new IllegalArgumentException("Incorrect number of fields in row. Expected: " + this.rowHeader.getFieldNames().size() + ", Got: " + row.size() + ", Row: " + row);
        }
        this.rawRows.add(new ArrayList<Comparable>(row));
        return this;
    }

    public Table addAll(List<List<Comparable>> rows) {
        rows.forEach(this::add);
        return this;
    }

    public Table addAllRows(List<Comparable[]> rows) {
        rows.forEach((? super T r) -> this.add(Arrays.asList(r)));
        return this;
    }

    public Table flip() {
        this.finishedAdding = true;
        this.sortAndLimit();
        return this;
    }

    private List<List<Comparable>> orderRows() {
        return (List)this.orderingFieldNameOptional.map(orderingColumnName -> this.rawRows.stream().sorted((row1, row2) -> {
            Comparable fieldForRow1 = (Comparable)row1.get(this.rowHeader.indexOf((String)orderingColumnName));
            Comparable fieldForRow2 = (Comparable)row2.get(this.rowHeader.indexOf((String)orderingColumnName));
            int cmpRawResult = fieldForRow1.compareTo(fieldForRow2);
            return (Integer)this.isDescendingOptional.map(isDescending -> isDescending != false ? -1 * cmpRawResult : cmpRawResult).orElse((Object)cmpRawResult);
        }).collect(Collectors.toList())).orElse(this.rawRows);
    }

    private void sortAndLimit() {
        this.renderRows = new ArrayList<List<String>>();
        int limit = (Integer)this.limitOptional.orElse((Object)this.rawRows.size());
        List<List<Comparable>> orderedRows = this.orderRows();
        this.renderRows = orderedRows.stream().limit(limit).map(row -> IntStream.range(0, this.rowHeader.getNumFields()).mapToObj(idx -> {
            String fieldName = this.rowHeader.get(idx);
            if (this.fieldNameToConverterMap.containsKey(fieldName)) {
                return this.fieldNameToConverterMap.get(fieldName).apply(row.get(idx));
            }
            Object v = row.get(idx);
            return v == null ? "null" : v.toString();
        }).collect(Collectors.toList())).collect(Collectors.toList());
    }

    @Override
    public Iterator<List<String>> iterator() {
        if (!this.finishedAdding) {
            throw new IllegalStateException("Container must be flipped before reading the data");
        }
        return this.renderRows.iterator();
    }

    @Override
    public void forEach(Consumer<? super List<String>> action) {
        if (!this.finishedAdding) {
            throw new IllegalStateException("Container must be flipped before reading the data");
        }
        this.renderRows.forEach(action);
    }

    public List<String> getFieldNames() {
        return this.rowHeader.getFieldNames();
    }

    public List<List<String>> getRenderRows() {
        return this.renderRows;
    }
}

