/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.block.HoodieCorruptBlock;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import scala.Tuple2;
import scala.Tuple3;

@Component
public class HoodieLogFileCommand
implements CommandMarker {
    @CliCommand(value={"show logfile metadata"}, help="Read commit metadata from log files")
    public String showLogFileCommits(@CliOption(key={"logFilePathPattern"}, mandatory=true, help="Fully qualified path for the log file") String logFilePathPattern, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        HoodieWrapperFileSystem fs = HoodieCLI.getTableMetaClient().getFs();
        List logFilePaths = FSUtils.getGlobStatusExcludingMetaFolder((FileSystem)fs, (Path)new Path(logFilePathPattern)).stream().map(status -> status.getPath().toString()).collect(Collectors.toList());
        HashMap commitCountAndMetadata = new HashMap();
        int numCorruptBlocks = 0;
        int dummyInstantTimeCount = 0;
        for (String logFilePath : logFilePaths) {
            FileStatus[] fsStatus = fs.listStatus(new Path(logFilePath));
            Schema schema = new AvroSchemaConverter().convert(Objects.requireNonNull(TableSchemaResolver.readSchemaFromLogFile((FileSystem)fs, (Path)new Path(logFilePath))));
            HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((FileSystem)fs, (HoodieLogFile)new HoodieLogFile(fsStatus[0].getPath()), (Schema)schema);
            while (reader.hasNext()) {
                String instantTime;
                HoodieLogBlock n = (HoodieLogBlock)reader.next();
                int recordCount = 0;
                if (n instanceof HoodieCorruptBlock) {
                    try {
                        instantTime = (String)n.getLogBlockHeader().get(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                        if (instantTime == null) {
                            throw new Exception("Invalid instant time " + instantTime);
                        }
                    }
                    catch (Exception e) {
                        instantTime = "corrupt_block_" + ++numCorruptBlocks;
                    }
                } else {
                    instantTime = (String)n.getLogBlockHeader().get(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                    if (instantTime == null) {
                        instantTime = "dummy_instant_time_" + ++dummyInstantTimeCount;
                    }
                    if (n instanceof HoodieDataBlock) {
                        recordCount = ((HoodieDataBlock)n).getRecords().size();
                    }
                }
                if (commitCountAndMetadata.containsKey(instantTime)) {
                    ((List)commitCountAndMetadata.get(instantTime)).add(new Tuple3((Object)n.getBlockType(), (Object)new Tuple2((Object)n.getLogBlockHeader(), (Object)n.getLogBlockFooter()), (Object)recordCount));
                    continue;
                }
                ArrayList<Tuple3> list = new ArrayList<Tuple3>();
                list.add(new Tuple3((Object)n.getBlockType(), (Object)new Tuple2((Object)n.getLogBlockHeader(), (Object)n.getLogBlockFooter()), (Object)recordCount));
                commitCountAndMetadata.put(instantTime, list);
            }
            reader.close();
        }
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        ObjectMapper objectMapper = new ObjectMapper();
        for (Map.Entry entry : commitCountAndMetadata.entrySet()) {
            String instantTime = (String)entry.getKey();
            for (Tuple3 tuple3 : (List)entry.getValue()) {
                Comparable[] output = new Comparable[]{instantTime, (Comparable)tuple3._3(), ((HoodieLogBlock.HoodieLogBlockType)tuple3._1()).toString(), objectMapper.writeValueAsString(((Tuple2)tuple3._2())._1()), objectMapper.writeValueAsString(((Tuple2)tuple3._2())._2())};
                rows.add(output);
            }
        }
        TableHeader header = new TableHeader().addTableHeaderField("InstantTime").addTableHeaderField("RecordCount").addTableHeaderField("BlockType").addTableHeaderField("HeaderMetadata").addTableHeaderField("FooterMetadata");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    @CliCommand(value={"show logfile records"}, help="Read records from log files")
    public String showLogFileRecords(@CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="10") Integer limit, @CliOption(key={"logFilePathPattern"}, mandatory=true, help="Fully qualified paths for the log files") String logFilePathPattern, @CliOption(key={"mergeRecords"}, help="If the records in the log files should be merged", unspecifiedDefaultValue="false") Boolean shouldMerge) throws IOException {
        System.out.println("===============> Showing only " + limit + " records <===============");
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        HoodieWrapperFileSystem fs = client.getFs();
        List logFilePaths = FSUtils.getGlobStatusExcludingMetaFolder((FileSystem)fs, (Path)new Path(logFilePathPattern)).stream().map(status -> status.getPath().toString()).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        assert (logFilePaths.size() > 0) : "There is no log file";
        AvroSchemaConverter converter = new AvroSchemaConverter();
        Schema readerSchema = converter.convert(Objects.requireNonNull(TableSchemaResolver.readSchemaFromLogFile((FileSystem)fs, (Path)new Path((String)logFilePaths.get(logFilePaths.size() - 1)))));
        ArrayList<Object> allRecords = new ArrayList<Object>();
        if (shouldMerge.booleanValue()) {
            System.out.println("===========================> MERGING RECORDS <===================");
            HoodieMergedLogRecordScanner scanner = HoodieMergedLogRecordScanner.newBuilder().withFileSystem((FileSystem)fs).withBasePath(client.getBasePath()).withLogFilePaths(logFilePaths).withReaderSchema(readerSchema).withLatestInstantTime(((HoodieInstant)client.getActiveTimeline().getCommitTimeline().lastInstant().get()).getTimestamp()).withReadBlocksLazily(Boolean.parseBoolean("false")).withReverseReader(Boolean.parseBoolean("false")).withBufferSize(0x1000000).withMaxMemorySizeInBytes(Long.valueOf(0x40000000L)).withSpillableMapBasePath("/tmp/").build();
            for (HoodieRecord hoodieRecord : scanner) {
                Option option = hoodieRecord.getData().getInsertValue(readerSchema);
                if (allRecords.size() >= limit) continue;
                allRecords.add(option.get());
            }
        } else {
            for (String logFile : logFilePaths) {
                Schema writerSchema = new AvroSchemaConverter().convert(Objects.requireNonNull(TableSchemaResolver.readSchemaFromLogFile((FileSystem)client.getFs(), (Path)new Path(logFile))));
                HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((FileSystem)fs, (HoodieLogFile)new HoodieLogFile(new Path(logFile)), (Schema)writerSchema);
                while (reader.hasNext()) {
                    HoodieLogBlock n = (HoodieLogBlock)reader.next();
                    if (!(n instanceof HoodieDataBlock)) continue;
                    HoodieDataBlock blk = (HoodieDataBlock)n;
                    List records = blk.getRecords();
                    for (IndexedRecord record : records) {
                        if (allRecords.size() >= limit) continue;
                        allRecords.add(record);
                    }
                }
                reader.close();
                if (allRecords.size() < limit) continue;
                break;
            }
        }
        String[][] rows = new String[allRecords.size()][];
        int i = 0;
        for (IndexedRecord indexedRecord : allRecords) {
            String[] data = new String[]{indexedRecord.toString()};
            rows[i] = data;
            ++i;
        }
        return HoodiePrintHelper.print(new String[]{"Records"}, rows);
    }
}

