/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.spark.api.java.JavaSparkContext;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class MetadataCommand
implements CommandMarker {
    private JavaSparkContext jsc;
    private static String metadataBaseDirectory;

    public static void setMetadataBaseDirectory(String metadataDir) {
        ValidationUtils.checkState((metadataBaseDirectory == null ? 1 : 0) != 0, (String)("metadataBaseDirectory is already set to " + metadataBaseDirectory));
        metadataBaseDirectory = metadataDir;
    }

    public static String getMetadataTableBasePath(String tableBasePath) {
        if (metadataBaseDirectory != null) {
            return metadataBaseDirectory;
        }
        return HoodieTableMetadata.getMetadataTableBasePath((String)tableBasePath);
    }

    @CliCommand(value={"metadata set"}, help="Set options for Metadata Table")
    public String set(@CliOption(key={"metadataDir"}, help="Directory to read/write metadata table (can be different from dataset)", unspecifiedDefaultValue="") String metadataDir) {
        if (!metadataDir.isEmpty()) {
            MetadataCommand.setMetadataBaseDirectory(metadataDir);
        }
        return "Ok";
    }

    @CliCommand(value={"metadata create"}, help="Create the Metadata Table if it does not exist")
    public String create() throws IOException {
        HoodieCLI.getTableMetaClient();
        Path metadataPath = new Path(MetadataCommand.getMetadataTableBasePath(HoodieCLI.basePath));
        try {
            FileStatus[] statuses = HoodieCLI.fs.listStatus(metadataPath);
            if (statuses.length > 0) {
                throw new RuntimeException("Metadata directory (" + metadataPath.toString() + ") not empty.");
            }
        }
        catch (FileNotFoundException e) {
            HoodieCLI.fs.mkdirs(metadataPath);
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        HoodieWriteConfig writeConfig = this.getWriteConfig();
        this.initJavaSparkContext();
        SparkHoodieBackedTableMetadataWriter.create((Configuration)HoodieCLI.conf, (HoodieWriteConfig)writeConfig, (HoodieEngineContext)new HoodieSparkEngineContext(this.jsc));
        return String.format("Created Metadata Table in %s (duration=%.2f secs)", metadataPath, (double)timer.endTimer() / 1000.0);
    }

    @CliCommand(value={"metadata delete"}, help="Remove the Metadata Table")
    public String delete() throws Exception {
        HoodieCLI.getTableMetaClient();
        Path metadataPath = new Path(MetadataCommand.getMetadataTableBasePath(HoodieCLI.basePath));
        try {
            FileStatus[] statuses = HoodieCLI.fs.listStatus(metadataPath);
            if (statuses.length > 0) {
                HoodieCLI.fs.delete(metadataPath, true);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return String.format("Removed Metadata Table from %s", metadataPath);
    }

    @CliCommand(value={"metadata init"}, help="Update the metadata table from commits since the creation")
    public String init(@CliOption(key={"readonly"}, unspecifiedDefaultValue="false", help="Open in read-only mode") boolean readOnly) throws Exception {
        HoodieCLI.getTableMetaClient();
        Path metadataPath = new Path(MetadataCommand.getMetadataTableBasePath(HoodieCLI.basePath));
        try {
            HoodieCLI.fs.listStatus(metadataPath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Metadata directory (" + metadataPath.toString() + ") does not exist.");
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        if (!readOnly) {
            HoodieWriteConfig writeConfig = this.getWriteConfig();
            this.initJavaSparkContext();
            SparkHoodieBackedTableMetadataWriter.create((Configuration)HoodieCLI.conf, (HoodieWriteConfig)writeConfig, (HoodieEngineContext)new HoodieSparkEngineContext(this.jsc));
        }
        String action = readOnly ? "Opened" : "Initialized";
        return String.format(action + " Metadata Table in %s (duration=%.2fsec)", metadataPath, (double)timer.endTimer() / 1000.0);
    }

    @CliCommand(value={"metadata stats"}, help="Print stats about the metadata")
    public String stats() throws IOException {
        HoodieCLI.getTableMetaClient();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metadata = new HoodieBackedTableMetadata(HoodieCLI.conf, config, HoodieCLI.basePath, "/tmp");
        Map stats = metadata.stats();
        StringBuffer out = new StringBuffer("\n");
        out.append(String.format("Base path: %s\n", MetadataCommand.getMetadataTableBasePath(HoodieCLI.basePath)));
        for (Map.Entry entry : stats.entrySet()) {
            out.append(String.format("%s: %s\n", entry.getKey(), entry.getValue()));
        }
        return out.toString();
    }

    @CliCommand(value={"metadata list-partitions"}, help="Print a list of all partitions from the metadata")
    public String listPartitions() throws IOException {
        HoodieCLI.getTableMetaClient();
        this.initJavaSparkContext();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metadata = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieSparkEngineContext(this.jsc), config, HoodieCLI.basePath, "/tmp");
        StringBuffer out = new StringBuffer("\n");
        if (!metadata.enabled()) {
            out.append("=== Metadata Table not initilized. Using file listing to get list of partitions. ===\n\n");
        }
        long t1 = System.currentTimeMillis();
        List partitions = metadata.getAllPartitionPaths();
        long t2 = System.currentTimeMillis();
        int[] count = new int[]{0};
        partitions.stream().sorted((p1, p2) -> p2.compareTo((String)p1)).forEach(p -> {
            out.append((String)p);
            count[0] = count[0] + 1;
            if (count[0] % 15 == 0) {
                out.append("\n");
            } else {
                out.append(", ");
            }
        });
        out.append(String.format("\n\n=== List of partitions retrieved in %.2fsec ===", (double)(t2 - t1) / 1000.0));
        return out.toString();
    }

    @CliCommand(value={"metadata list-files"}, help="Print a list of all files in a partition from the metadata")
    public String listFiles(@CliOption(key={"partition"}, help="Name of the partition to list files", mandatory=true) String partition) throws IOException {
        HoodieCLI.getTableMetaClient();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metaReader = new HoodieBackedTableMetadata(HoodieCLI.conf, config, HoodieCLI.basePath, "/tmp");
        StringBuffer out = new StringBuffer("\n");
        if (!metaReader.enabled()) {
            out.append("=== Metadata Table not initialized. Using file listing to get list of files in partition. ===\n\n");
        }
        long t1 = System.currentTimeMillis();
        FileStatus[] statuses = metaReader.getAllFilesInPartition(new Path(HoodieCLI.basePath, partition));
        long t2 = System.currentTimeMillis();
        Arrays.stream(statuses).sorted((p1, p2) -> p2.getPath().getName().compareTo(p1.getPath().getName())).forEach(p -> {
            out.append("\t" + p.getPath().getName());
            out.append("\n");
        });
        out.append(String.format("\n=== Files in partition retrieved in %.2fsec ===", (double)(t2 - t1) / 1000.0));
        return out.toString();
    }

    private HoodieWriteConfig getWriteConfig() {
        return HoodieWriteConfig.newBuilder().withPath(HoodieCLI.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).build()).build();
    }

    private void initJavaSparkContext() {
        if (this.jsc == null) {
            this.jsc = SparkUtil.initJavaSparkConf("HoodieClI");
        }
    }
}

