/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.cli.DeDupeType;
import org.apache.hudi.cli.DedupeSparkJob;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.action.compact.strategy.UnBoundedCompactionStrategy;
import org.apache.hudi.table.upgrade.SparkUpgradeDowngrade;
import org.apache.hudi.utilities.HDFSParquetImporter;
import org.apache.hudi.utilities.HoodieCleaner;
import org.apache.hudi.utilities.HoodieCompactionAdminTool;
import org.apache.hudi.utilities.HoodieCompactor;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.deltastreamer.BootstrapExecutor;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;

public class SparkMain {
    private static final Logger LOG = Logger.getLogger(SparkMain.class);

    public static void main(String[] args) throws Exception {
        String command = args[0];
        LOG.info((Object)("Invoking SparkMain:" + command));
        SparkCommand cmd = SparkCommand.valueOf(command);
        JavaSparkContext jsc = SparkMain.sparkMasterContained(cmd) ? SparkUtil.initJavaSparkConf("hoodie-cli-" + command, (Option<String>)Option.of((Object)args[1]), (Option<String>)Option.of((Object)args[2])) : SparkUtil.initJavaSparkConf("hoodie-cli-" + command);
        int returnCode = 0;
        switch (cmd) {
            case ROLLBACK: {
                assert (args.length == 5);
                returnCode = SparkMain.rollback(jsc, args[3], args[4]);
                break;
            }
            case DEDUPLICATE: {
                assert (args.length == 8);
                returnCode = SparkMain.deduplicatePartitionPath(jsc, args[3], args[4], args[5], Boolean.parseBoolean(args[6]), args[7]);
                break;
            }
            case ROLLBACK_TO_SAVEPOINT: {
                assert (args.length == 5);
                returnCode = SparkMain.rollbackToSavepoint(jsc, args[3], args[4]);
                break;
            }
            case IMPORT: 
            case UPSERT: {
                assert (args.length >= 13);
                String propsFilePath = null;
                if (!StringUtils.isNullOrEmpty((String)args[12])) {
                    propsFilePath = args[12];
                }
                ArrayList<String> configs = new ArrayList<String>();
                if (args.length > 13) {
                    configs.addAll(Arrays.asList(args).subList(13, args.length));
                }
                returnCode = SparkMain.dataLoad(jsc, command, args[3], args[4], args[5], args[6], args[7], args[8], Integer.parseInt(args[9]), args[10], Integer.parseInt(args[11]), propsFilePath, configs);
                break;
            }
            case COMPACT_RUN: {
                assert (args.length >= 9);
                String propsFilePath = null;
                if (!StringUtils.isNullOrEmpty((String)args[8])) {
                    propsFilePath = args[8];
                }
                ArrayList<String> configs = new ArrayList<String>();
                if (args.length > 9) {
                    configs.addAll(Arrays.asList(args).subList(9, args.length));
                }
                returnCode = SparkMain.compact(jsc, args[1], args[2], args[3], Integer.parseInt(args[4]), args[5], args[6], Integer.parseInt(args[7]), false, propsFilePath, configs);
                break;
            }
            case COMPACT_SCHEDULE: {
                assert (args.length >= 6);
                String propsFilePath = null;
                if (!StringUtils.isNullOrEmpty((String)args[5])) {
                    propsFilePath = args[5];
                }
                ArrayList<String> configs = new ArrayList<String>();
                if (args.length > 6) {
                    configs.addAll(Arrays.asList(args).subList(6, args.length));
                }
                returnCode = SparkMain.compact(jsc, args[1], args[2], args[3], 1, "", args[4], 0, true, propsFilePath, configs);
                break;
            }
            case COMPACT_VALIDATE: {
                assert (args.length == 7);
                SparkMain.doCompactValidate(jsc, args[3], args[4], args[5], Integer.parseInt(args[6]));
                returnCode = 0;
                break;
            }
            case COMPACT_REPAIR: {
                assert (args.length == 8);
                SparkMain.doCompactRepair(jsc, args[3], args[4], args[5], Integer.parseInt(args[6]), Boolean.parseBoolean(args[7]));
                returnCode = 0;
                break;
            }
            case COMPACT_UNSCHEDULE_FILE: {
                assert (args.length == 9);
                SparkMain.doCompactUnscheduleFile(jsc, args[3], args[4], args[5], Integer.parseInt(args[6]), Boolean.parseBoolean(args[7]), Boolean.parseBoolean(args[8]));
                returnCode = 0;
                break;
            }
            case COMPACT_UNSCHEDULE_PLAN: {
                assert (args.length == 9);
                SparkMain.doCompactUnschedule(jsc, args[3], args[4], args[5], Integer.parseInt(args[6]), Boolean.parseBoolean(args[7]), Boolean.parseBoolean(args[8]));
                returnCode = 0;
                break;
            }
            case CLEAN: {
                assert (args.length >= 5);
                String propsFilePath = null;
                if (!StringUtils.isNullOrEmpty((String)args[4])) {
                    propsFilePath = args[4];
                }
                ArrayList<String> configs = new ArrayList<String>();
                if (args.length > 5) {
                    configs.addAll(Arrays.asList(args).subList(5, args.length));
                }
                SparkMain.clean(jsc, args[3], propsFilePath, configs);
                break;
            }
            case SAVEPOINT: {
                assert (args.length == 7);
                returnCode = SparkMain.createSavepoint(jsc, args[3], args[4], args[5], args[6]);
                break;
            }
            case DELETE_SAVEPOINT: {
                assert (args.length == 5);
                returnCode = SparkMain.deleteSavepoint(jsc, args[3], args[4]);
                break;
            }
            case BOOTSTRAP: {
                assert (args.length >= 18);
                String propsFilePath = null;
                if (!StringUtils.isNullOrEmpty((String)args[17])) {
                    propsFilePath = args[17];
                }
                ArrayList<String> configs = new ArrayList<String>();
                if (args.length > 18) {
                    configs.addAll(Arrays.asList(args).subList(18, args.length));
                }
                returnCode = SparkMain.doBootstrap(jsc, args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16], propsFilePath, configs);
                break;
            }
            case UPGRADE: 
            case DOWNGRADE: {
                assert (args.length == 5);
                returnCode = SparkMain.upgradeOrDowngradeTable(jsc, args[3], args[4]);
                break;
            }
        }
        System.exit(returnCode);
    }

    private static boolean sparkMasterContained(SparkCommand command) {
        List<SparkCommand> masterContained = Arrays.asList(SparkCommand.COMPACT_VALIDATE, SparkCommand.COMPACT_REPAIR, SparkCommand.COMPACT_UNSCHEDULE_PLAN, SparkCommand.COMPACT_UNSCHEDULE_FILE, SparkCommand.CLEAN, SparkCommand.IMPORT, SparkCommand.UPSERT, SparkCommand.DEDUPLICATE, SparkCommand.SAVEPOINT, SparkCommand.DELETE_SAVEPOINT, SparkCommand.ROLLBACK_TO_SAVEPOINT, SparkCommand.ROLLBACK, SparkCommand.BOOTSTRAP);
        return masterContained.contains((Object)command);
    }

    protected static void clean(JavaSparkContext jsc, String basePath, String propsFilePath, List<String> configs) {
        HoodieCleaner.Config cfg = new HoodieCleaner.Config();
        cfg.basePath = basePath;
        cfg.propsFilePath = propsFilePath;
        cfg.configs = configs;
        new HoodieCleaner(cfg, jsc).run();
    }

    private static int dataLoad(JavaSparkContext jsc, String command, String srcPath, String targetPath, String tableName, String tableType, String rowKey, String partitionKey, int parallelism, String schemaFile, int retry, String propsFilePath, List<String> configs) {
        HDFSParquetImporter.Config cfg = new HDFSParquetImporter.Config();
        cfg.command = command;
        cfg.srcPath = srcPath;
        cfg.targetPath = targetPath;
        cfg.tableName = tableName;
        cfg.tableType = tableType;
        cfg.rowKey = rowKey;
        cfg.partitionKey = partitionKey;
        cfg.parallelism = parallelism;
        cfg.schemaFile = schemaFile;
        cfg.propsFilePath = propsFilePath;
        cfg.configs = configs;
        return new HDFSParquetImporter(cfg).dataImport(jsc, retry);
    }

    private static void doCompactValidate(JavaSparkContext jsc, String basePath, String compactionInstant, String outputPath, int parallelism) throws Exception {
        HoodieCompactionAdminTool.Config cfg = new HoodieCompactionAdminTool.Config();
        cfg.basePath = basePath;
        cfg.operation = HoodieCompactionAdminTool.Operation.VALIDATE;
        cfg.outputPath = outputPath;
        cfg.compactionInstantTime = compactionInstant;
        cfg.parallelism = parallelism;
        new HoodieCompactionAdminTool(cfg).run(jsc);
    }

    private static void doCompactRepair(JavaSparkContext jsc, String basePath, String compactionInstant, String outputPath, int parallelism, boolean dryRun) throws Exception {
        HoodieCompactionAdminTool.Config cfg = new HoodieCompactionAdminTool.Config();
        cfg.basePath = basePath;
        cfg.operation = HoodieCompactionAdminTool.Operation.REPAIR;
        cfg.outputPath = outputPath;
        cfg.compactionInstantTime = compactionInstant;
        cfg.parallelism = parallelism;
        cfg.dryRun = dryRun;
        new HoodieCompactionAdminTool(cfg).run(jsc);
    }

    private static void doCompactUnschedule(JavaSparkContext jsc, String basePath, String compactionInstant, String outputPath, int parallelism, boolean skipValidation, boolean dryRun) throws Exception {
        HoodieCompactionAdminTool.Config cfg = new HoodieCompactionAdminTool.Config();
        cfg.basePath = basePath;
        cfg.operation = HoodieCompactionAdminTool.Operation.UNSCHEDULE_PLAN;
        cfg.outputPath = outputPath;
        cfg.compactionInstantTime = compactionInstant;
        cfg.parallelism = parallelism;
        cfg.dryRun = dryRun;
        cfg.skipValidation = skipValidation;
        new HoodieCompactionAdminTool(cfg).run(jsc);
    }

    private static void doCompactUnscheduleFile(JavaSparkContext jsc, String basePath, String fileId, String outputPath, int parallelism, boolean skipValidation, boolean dryRun) throws Exception {
        HoodieCompactionAdminTool.Config cfg = new HoodieCompactionAdminTool.Config();
        cfg.basePath = basePath;
        cfg.operation = HoodieCompactionAdminTool.Operation.UNSCHEDULE_FILE;
        cfg.outputPath = outputPath;
        cfg.fileId = fileId;
        cfg.parallelism = parallelism;
        cfg.dryRun = dryRun;
        cfg.skipValidation = skipValidation;
        new HoodieCompactionAdminTool(cfg).run(jsc);
    }

    private static int compact(JavaSparkContext jsc, String basePath, String tableName, String compactionInstant, int parallelism, String schemaFile, String sparkMemory, int retry, boolean schedule, String propsFilePath, List<String> configs) {
        HoodieCompactor.Config cfg = new HoodieCompactor.Config();
        cfg.basePath = basePath;
        cfg.tableName = tableName;
        cfg.compactionInstantTime = compactionInstant;
        cfg.strategyClassName = UnBoundedCompactionStrategy.class.getCanonicalName();
        cfg.parallelism = parallelism;
        cfg.schemaFile = schemaFile;
        cfg.runSchedule = schedule;
        cfg.propsFilePath = propsFilePath;
        cfg.configs = configs;
        jsc.getConf().set("spark.executor.memory", sparkMemory);
        return new HoodieCompactor(jsc, cfg).compact(retry);
    }

    private static int deduplicatePartitionPath(JavaSparkContext jsc, String duplicatedPartitionPath, String repairedOutputPath, String basePath, boolean dryRun, String dedupeType) {
        DedupeSparkJob job = new DedupeSparkJob(basePath, duplicatedPartitionPath, repairedOutputPath, new SQLContext(jsc), FSUtils.getFs((String)basePath, (Configuration)jsc.hadoopConfiguration()), DeDupeType.withName(dedupeType));
        job.fixDuplicates(dryRun);
        return 0;
    }

    private static int doBootstrap(JavaSparkContext jsc, String tableName, String tableType, String basePath, String sourcePath, String recordKeyCols, String partitionFields, String parallelism, String schemaProviderClass, String bootstrapIndexClass, String selectorClass, String keyGeneratorClass, String fullBootstrapInputProvider, String payloadClassName, String enableHiveSync, String propsFilePath, List<String> configs) throws IOException {
        TypedProperties properties = propsFilePath == null ? UtilHelpers.buildProperties(configs) : UtilHelpers.readConfig((FileSystem)FSUtils.getFs((String)propsFilePath, (Configuration)jsc.hadoopConfiguration()), (Path)new Path(propsFilePath), configs).getConfig();
        properties.setProperty("hoodie.bootstrap.base.path", sourcePath);
        properties.setProperty("hoodie.bootstrap.keygen.class", keyGeneratorClass);
        properties.setProperty("hoodie.bootstrap.full.input.provider", fullBootstrapInputProvider);
        properties.setProperty("hoodie.bootstrap.parallelism", parallelism);
        properties.setProperty("hoodie.bootstrap.mode.selector", selectorClass);
        properties.setProperty(DataSourceWriteOptions.RECORDKEY_FIELD_OPT_KEY(), recordKeyCols);
        properties.setProperty(DataSourceWriteOptions.PARTITIONPATH_FIELD_OPT_KEY(), partitionFields);
        HoodieDeltaStreamer.Config cfg = new HoodieDeltaStreamer.Config();
        cfg.targetTableName = tableName;
        cfg.targetBasePath = basePath;
        cfg.tableType = tableType;
        cfg.schemaProviderClassName = schemaProviderClass;
        cfg.bootstrapIndexClass = bootstrapIndexClass;
        cfg.payloadClassName = payloadClassName;
        cfg.enableHiveSync = Boolean.valueOf(enableHiveSync);
        new BootstrapExecutor(cfg, jsc, FSUtils.getFs((String)basePath, (Configuration)jsc.hadoopConfiguration()), jsc.hadoopConfiguration(), properties).execute();
        return 0;
    }

    private static int rollback(JavaSparkContext jsc, String instantTime, String basePath) throws Exception {
        SparkRDDWriteClient client = SparkMain.createHoodieClient(jsc, basePath);
        if (client.rollback(instantTime)) {
            LOG.info((Object)String.format("The commit \"%s\" rolled back.", instantTime));
            return 0;
        }
        LOG.warn((Object)String.format("The commit \"%s\" failed to roll back.", instantTime));
        return -1;
    }

    private static int createSavepoint(JavaSparkContext jsc, String commitTime, String user, String comments, String basePath) throws Exception {
        SparkRDDWriteClient client = SparkMain.createHoodieClient(jsc, basePath);
        try {
            client.savepoint(commitTime, user, comments);
            LOG.info((Object)String.format("The commit \"%s\" has been savepointed.", commitTime));
            return 0;
        }
        catch (HoodieSavepointException se) {
            LOG.warn((Object)String.format("Failed: Could not create savepoint \"%s\".", commitTime));
            return -1;
        }
    }

    private static int rollbackToSavepoint(JavaSparkContext jsc, String savepointTime, String basePath) throws Exception {
        SparkRDDWriteClient client = SparkMain.createHoodieClient(jsc, basePath);
        try {
            client.restoreToSavepoint(savepointTime);
            LOG.info((Object)String.format("The commit \"%s\" rolled back.", savepointTime));
            return 0;
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("The commit \"%s\" failed to roll back.", savepointTime));
            return -1;
        }
    }

    private static int deleteSavepoint(JavaSparkContext jsc, String savepointTime, String basePath) throws Exception {
        SparkRDDWriteClient client = SparkMain.createHoodieClient(jsc, basePath);
        try {
            client.deleteSavepoint(savepointTime);
            LOG.info((Object)String.format("Savepoint \"%s\" deleted.", savepointTime));
            return 0;
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Failed: Could not delete savepoint \"%s\".", savepointTime));
            return -1;
        }
    }

    protected static int upgradeOrDowngradeTable(JavaSparkContext jsc, String basePath, String toVersion) {
        HoodieWriteConfig config = SparkMain.getWriteConfig(basePath);
        HoodieTableMetaClient metaClient = new HoodieTableMetaClient(jsc.hadoopConfiguration(), config.getBasePath(), false, config.getConsistencyGuardConfig(), Option.of((Object)new TimelineLayoutVersion(config.getTimelineLayoutVersion())));
        try {
            new SparkUpgradeDowngrade(metaClient, config, (HoodieEngineContext)new HoodieSparkEngineContext(jsc)).run(metaClient, HoodieTableVersion.valueOf((String)toVersion), config, (HoodieEngineContext)new HoodieSparkEngineContext(jsc), null);
            LOG.info((Object)String.format("Table at \"%s\" upgraded / downgraded to version \"%s\".", basePath, toVersion));
            return 0;
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Failed: Could not upgrade/downgrade table at \"%s\" to version \"%s\".", basePath, toVersion), (Throwable)e);
            return -1;
        }
    }

    private static SparkRDDWriteClient createHoodieClient(JavaSparkContext jsc, String basePath) throws Exception {
        HoodieWriteConfig config = SparkMain.getWriteConfig(basePath);
        return new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(jsc), config);
    }

    private static HoodieWriteConfig getWriteConfig(String basePath) {
        return HoodieWriteConfig.newBuilder().withPath(basePath).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).build();
    }

    static enum SparkCommand {
        BOOTSTRAP,
        ROLLBACK,
        DEDUPLICATE,
        ROLLBACK_TO_SAVEPOINT,
        SAVEPOINT,
        IMPORT,
        UPSERT,
        COMPACT_SCHEDULE,
        COMPACT_RUN,
        COMPACT_UNSCHEDULE_PLAN,
        COMPACT_UNSCHEDULE_FILE,
        COMPACT_VALIDATE,
        COMPACT_REPAIR,
        CLEAN,
        DELETE_SAVEPOINT,
        UPGRADE,
        DOWNGRADE;

    }
}

