/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.TableNotFoundException;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class TableCommand
implements CommandMarker {
    @CliCommand(value={"connect"}, help="Connect to a hoodie table")
    public String connect(@CliOption(key={"path"}, mandatory=true, help="Base Path of the table") String path, @CliOption(key={"layoutVersion"}, help="Timeline Layout version") Integer layoutVersion, @CliOption(key={"eventuallyConsistent"}, unspecifiedDefaultValue="false", help="Enable eventual consistency") boolean eventuallyConsistent, @CliOption(key={"initialCheckIntervalMs"}, unspecifiedDefaultValue="2000", help="Initial wait time for eventual consistency") Integer initialConsistencyIntervalMs, @CliOption(key={"maxWaitIntervalMs"}, unspecifiedDefaultValue="300000", help="Max wait time for eventual consistency") Integer maxConsistencyIntervalMs, @CliOption(key={"maxCheckIntervalMs"}, unspecifiedDefaultValue="7", help="Max checks for eventual consistency") Integer maxConsistencyChecks) throws IOException {
        HoodieCLI.setConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(eventuallyConsistent).withInitialConsistencyCheckIntervalMs(initialConsistencyIntervalMs.intValue()).withMaxConsistencyCheckIntervalMs(maxConsistencyIntervalMs.intValue()).withMaxConsistencyChecks(maxConsistencyChecks.intValue()).build());
        HoodieCLI.initConf();
        HoodieCLI.connectTo(path, layoutVersion);
        HoodieCLI.initFS(true);
        HoodieCLI.state = HoodieCLI.CLIState.TABLE;
        return "Metadata for table " + HoodieCLI.getTableMetaClient().getTableConfig().getTableName() + " loaded";
    }

    @CliCommand(value={"create"}, help="Create a hoodie table if not present")
    public String createTable(@CliOption(key={"path"}, mandatory=true, help="Base Path of the table") String path, @CliOption(key={"tableName"}, mandatory=true, help="Hoodie Table Name") String name, @CliOption(key={"tableType"}, unspecifiedDefaultValue="COPY_ON_WRITE", help="Hoodie Table Type. Must be one of : COPY_ON_WRITE or MERGE_ON_READ") String tableTypeStr, @CliOption(key={"archiveLogFolder"}, help="Folder Name for storing archived timeline") String archiveFolder, @CliOption(key={"layoutVersion"}, help="Specific Layout Version to use") Integer layoutVersion, @CliOption(key={"payloadClass"}, unspecifiedDefaultValue="org.apache.hudi.common.model.HoodieAvroPayload", help="Payload Class") String payloadClass) throws IOException {
        boolean initialized = HoodieCLI.initConf();
        HoodieCLI.initFS(initialized);
        boolean existing = false;
        try {
            new HoodieTableMetaClient(HoodieCLI.conf, path);
            existing = true;
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        if (existing) {
            throw new IllegalStateException("Table already existing in path : " + path);
        }
        HoodieTableType tableType = HoodieTableType.valueOf((String)tableTypeStr);
        HoodieTableMetaClient.initTableType((Configuration)HoodieCLI.conf, (String)path, (HoodieTableType)tableType, (String)name, (String)archiveFolder, (String)payloadClass, (Integer)layoutVersion);
        return this.connect(path, layoutVersion, false, 0, 0, 0);
    }

    @CliCommand(value={"desc"}, help="Describe Hoodie Table properties")
    public String descTable() {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        TableHeader header = new TableHeader().addTableHeaderField("Property").addTableHeaderField("Value");
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        rows.add(new Comparable[]{"basePath", client.getBasePath()});
        rows.add(new Comparable[]{"metaPath", client.getMetaPath()});
        rows.add(new Comparable[]{"fileSystem", client.getFs().getScheme()});
        client.getTableConfig().getProps().entrySet().forEach(e -> rows.add(new Comparable[]{(Comparable)e.getKey(), (Comparable)e.getValue()}));
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, -1, false, rows);
    }

    @CliCommand(value={"refresh", "metadata refresh", "commits refresh", "cleans refresh", "savepoints refresh"}, help="Refresh table metadata")
    public String refreshMetadata() {
        HoodieCLI.refreshTableMetadata();
        return "Metadata for table " + HoodieCLI.getTableMetaClient().getTableConfig().getTableName() + " refreshed.";
    }

    static {
        System.out.println("Table command getting loaded");
    }
}

