/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.exception.HoodieException;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class TempViewCommand
implements CommandMarker {
    public static final String QUERY_SUCCESS = "Query ran successfully!";
    public static final String QUERY_FAIL = "Query ran failed!";
    public static final String SHOW_SUCCESS = "Show all views name successfully!";

    @CliCommand(value={"temp_query", "temp query"}, help="query against created temp view")
    public String query(@CliOption(key={"sql"}, mandatory=true, help="select query to run against view") String sql) {
        try {
            HoodieCLI.getTempViewProvider().runQuery(sql);
            return QUERY_SUCCESS;
        }
        catch (HoodieException ex) {
            return QUERY_FAIL;
        }
    }

    @CliCommand(value={"temps_show", "temps show"}, help="Show all views name")
    public String showAll() {
        try {
            HoodieCLI.getTempViewProvider().showAllViews();
            return SHOW_SUCCESS;
        }
        catch (HoodieException ex) {
            return "Show all views name failed!";
        }
    }

    @CliCommand(value={"temp_delete", "temp delete"}, help="Delete view name")
    public String delete(@CliOption(key={"view"}, mandatory=true, help="view name") String tableName) {
        try {
            HoodieCLI.getTempViewProvider().deleteTable(tableName);
            return String.format("Delete view %s successfully!", tableName);
        }
        catch (HoodieException ex) {
            return String.format("Delete view %s failed!", tableName);
        }
    }
}

