/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class UpgradeOrDowngradeCommand
implements CommandMarker {
    @CliCommand(value={"upgrade hoodie dataset "}, help="Upgrades hoodie dataset")
    public String upgradeHoodieDataset(@CliOption(key={"toVersion"}, help="To version of Hoodie dataset to be upgraded/downgraded to", unspecifiedDefaultValue="") String toVersion, @CliOption(key={"sparkProperties"}, help="Spark Properties File Path") String sparkPropertiesPath, @CliOption(key={"sparkMaster"}, unspecifiedDefaultValue="", help="Spark Master") String master, @CliOption(key={"sparkMemory"}, unspecifiedDefaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.UPGRADE.toString(), master, sparkMemory, metaClient.getBasePath(), toVersion});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not Upgrade/Downgrade Hoodie dataset to \"%s\".", toVersion);
        }
        return String.format("Hoodie dataset upgraded/downgraded to ", toVersion);
    }

    @CliCommand(value={"downgrade hoodie dataset "}, help="Upgrades hoodie dataset")
    public String downgradeHoodieDataset(@CliOption(key={"toVersion"}, help="To version of Hoodie dataset to be upgraded/downgraded to", unspecifiedDefaultValue="") String toVersion, @CliOption(key={"sparkProperties"}, help="Spark Properties File Path") String sparkPropertiesPath, @CliOption(key={"sparkMaster"}, unspecifiedDefaultValue="", help="Spark Master") String master, @CliOption(key={"sparkMemory"}, unspecifiedDefaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.DOWNGRADE.toString(), master, sparkMemory, metaClient.getBasePath(), toVersion});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not Upgrade/Downgrade Hoodie dataset to \"%s\".", toVersion);
        }
        return String.format("Hoodie dataset upgraded/downgraded to ", toVersion);
    }
}

