/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.common.util.StringUtils;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class UtilsCommand
implements CommandMarker {
    @CliCommand(value={"utils loadClass"}, help="Load a class")
    public String loadClass(@CliOption(key={"class"}, help="Check mode") String clazz) {
        if (StringUtils.isNullOrEmpty((String)clazz)) {
            return "Class to be loaded can not be null!";
        }
        try {
            Class<?> klass = Class.forName(clazz);
            return klass.getProtectionDomain().getCodeSource().getLocation().toExternalForm();
        }
        catch (ClassNotFoundException e) {
            return String.format("Class %s not found!", clazz);
        }
    }
}

