/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.utils;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.cli.commands.SparkEnvCommand;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.launcher.SparkLauncher;

public class SparkUtil {
    private static final String DEFAULT_SPARK_MASTER = "yarn";

    public static SparkLauncher initLauncher(String propertiesFile) throws URISyntaxException {
        String currentJar = new File(SparkUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getAbsolutePath();
        Map<String, String> env = SparkEnvCommand.env;
        SparkLauncher sparkLauncher = new SparkLauncher(env).setAppResource(currentJar).setMainClass(SparkMain.class.getName());
        if (!StringUtils.isNullOrEmpty((String)propertiesFile)) {
            sparkLauncher.setPropertiesFile(propertiesFile);
        }
        File libDirectory = new File(new File(currentJar).getParent(), "lib");
        for (String library : Objects.requireNonNull(libDirectory.list())) {
            sparkLauncher.addJar(new File(libDirectory, library).getAbsolutePath());
        }
        return sparkLauncher;
    }

    public static JavaSparkContext initJavaSparkConf(String name) {
        return SparkUtil.initJavaSparkConf(name, (Option<String>)Option.empty(), (Option<String>)Option.empty());
    }

    public static JavaSparkContext initJavaSparkConf(String name, Option<String> master, Option<String> executorMemory) {
        SparkConf sparkConf = new SparkConf().setAppName(name);
        String defMaster = (String)master.orElse((Object)sparkConf.getenv("SPARK_MASTER"));
        if (null == defMaster || defMaster.isEmpty()) {
            sparkConf.setMaster(DEFAULT_SPARK_MASTER);
        } else {
            sparkConf.setMaster(defMaster);
        }
        sparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.set("spark.driver.maxResultSize", "2g");
        sparkConf.set("spark.eventLog.overwrite", "true");
        sparkConf.set("spark.eventLog.enabled", "true");
        if (executorMemory.isPresent()) {
            sparkConf.set("spark.executor.memory", (String)executorMemory.get());
        }
        sparkConf.set("spark.hadoop.mapred.output.compress", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        sparkConf.set("spark.hadoop.mapred.output.compression.type", "BLOCK");
        SparkRDDWriteClient.registerClasses((SparkConf)sparkConf);
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        jsc.hadoopConfiguration().setBoolean("parquet.enable.summary-metadata", false);
        FSUtils.prepareHadoopConf((Configuration)jsc.hadoopConfiguration());
        return jsc;
    }
}

