/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.cli.utils.SparkTempViewProvider;
import org.apache.hudi.cli.utils.TempViewProvider;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;

public class HoodieCLI {
    public static StorageConfiguration<Configuration> conf;
    public static ConsistencyGuardConfig consistencyGuardConfig;
    public static HoodieTimeGeneratorConfig timeGeneratorConfig;
    public static HoodieStorage storage;
    public static CLIState state;
    public static String basePath;
    protected static HoodieTableMetaClient tableMetadata;
    public static HoodieTableMetaClient syncTableMetadata;
    public static TempViewProvider tempViewProvider;

    public static void setConsistencyGuardConfig(ConsistencyGuardConfig config) {
        consistencyGuardConfig = config;
    }

    public static void setTimeGeneratorConfig(HoodieTimeGeneratorConfig config) {
        timeGeneratorConfig = config;
    }

    private static void setTableMetaClient(HoodieTableMetaClient tableMetadata) {
        HoodieCLI.tableMetadata = tableMetadata;
    }

    private static void setBasePath(String basePath) {
        HoodieCLI.basePath = basePath;
    }

    public static boolean initConf() {
        if (conf == null) {
            conf = HadoopFSUtils.getStorageConf((Configuration)HadoopFSUtils.prepareHadoopConf((Configuration)new Configuration()));
            return true;
        }
        return false;
    }

    public static void initFS(boolean force) throws IOException {
        if (storage == null || force) {
            storage = tableMetadata != null ? tableMetadata.getStorage() : new HoodieHadoopStorage(FileSystem.get((Configuration)((Configuration)conf.unwrap())));
        }
    }

    public static void refreshTableMetadata() {
        HoodieCLI.setTableMetaClient(HoodieTableMetaClient.builder().setConf(conf.newInstance()).setBasePath(basePath).setLoadActiveTimelineOnLoad(false).setConsistencyGuardConfig(consistencyGuardConfig).setTimeGeneratorConfig(timeGeneratorConfig == null ? HoodieTimeGeneratorConfig.defaultConfig((String)basePath) : timeGeneratorConfig).build());
    }

    public static void connectTo(String basePath) {
        HoodieCLI.setBasePath(basePath);
        HoodieCLI.refreshTableMetadata();
    }

    public static HoodieTableMetaClient getTableMetaClient() {
        if (tableMetadata == null) {
            throw new NullPointerException("There is no hudi table. Please use connect command to set table first");
        }
        return tableMetadata;
    }

    public static synchronized TempViewProvider getTempViewProvider() {
        if (tempViewProvider == null) {
            tempViewProvider = new SparkTempViewProvider(HoodieCLI.class.getSimpleName());
        }
        return tempViewProvider;
    }

    static {
        consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().build();
        state = CLIState.INIT;
    }

    public static enum CLIState {
        INIT,
        TABLE,
        SYNC;

    }
}

