/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.HoodieTableHeaderFields;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.cli.utils.CommitUtil;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparator;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.NumericUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class CommitsCommand {
    private String printCommits(HoodieTimeline timeline, Integer limit, String sortByField, boolean descending, boolean headerOnly, String tempTableName) throws IOException {
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        InstantComparator instantComparator = HoodieCLI.getTableMetaClient().getTimelineLayout().getInstantComparator();
        List commits = timeline.getCommitsTimeline().filterCompletedInstants().getInstantsAsStream().sorted(instantComparator.requestedTimeOrderedComparator().reversed()).collect(Collectors.toList());
        for (HoodieInstant commit : commits) {
            HoodieCommitMetadata commitMetadata = timeline.readCommitMetadata(commit);
            rows.add(new Comparable[]{commit.requestedTime(), Long.valueOf(commitMetadata.fetchTotalBytesWritten()), Long.valueOf(commitMetadata.fetchTotalFilesInsert()), Long.valueOf(commitMetadata.fetchTotalFilesUpdated()), Long.valueOf(commitMetadata.fetchTotalPartitionsWritten()), Long.valueOf(commitMetadata.fetchTotalRecordsWritten()), Long.valueOf(commitMetadata.fetchTotalUpdateRecordsWritten()), Long.valueOf(commitMetadata.fetchTotalWriteErrors())});
        }
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Bytes Written", entry -> NumericUtils.humanReadableByteCount((double)Double.parseDouble(entry.toString())));
        TableHeader header = HoodieTableHeaderFields.getTableHeader();
        return HoodiePrintHelper.print(header, fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows, tempTableName);
    }

    private String printCommitsWithMetadata(HoodieTimeline timeline, Integer limit, String sortByField, boolean descending, boolean headerOnly, String tempTableName, String partition) throws IOException {
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        InstantComparator instantComparator = HoodieCLI.getTableMetaClient().getTimelineLayout().getInstantComparator();
        List commits = timeline.getCommitsTimeline().filterCompletedInstants().getInstantsAsStream().sorted(instantComparator.requestedTimeOrderedComparator().reversed()).collect(Collectors.toList());
        for (HoodieInstant commit : commits) {
            HoodieCommitMetadata commitMetadata = timeline.readCommitMetadata(commit);
            for (Map.Entry partitionWriteStat : commitMetadata.getPartitionToWriteStats().entrySet()) {
                for (HoodieWriteStat hoodieWriteStat : (List)partitionWriteStat.getValue()) {
                    if (!StringUtils.isNullOrEmpty((String)partition) && !partition.equals(hoodieWriteStat.getPartitionPath())) continue;
                    rows.add(new Comparable[]{commit.getAction(), commit.requestedTime(), hoodieWriteStat.getPartitionPath(), hoodieWriteStat.getFileId(), hoodieWriteStat.getPrevCommit(), Long.valueOf(hoodieWriteStat.getNumWrites()), Long.valueOf(hoodieWriteStat.getNumInserts()), Long.valueOf(hoodieWriteStat.getNumDeletes()), Long.valueOf(hoodieWriteStat.getNumUpdateWrites()), Long.valueOf(hoodieWriteStat.getTotalWriteErrors()), Long.valueOf(hoodieWriteStat.getTotalLogBlocks()), Long.valueOf(hoodieWriteStat.getTotalCorruptLogBlock()), Long.valueOf(hoodieWriteStat.getTotalRollbackBlocks()), Long.valueOf(hoodieWriteStat.getTotalLogRecords()), Long.valueOf(hoodieWriteStat.getTotalUpdatedRecordsCompacted()), Long.valueOf(hoodieWriteStat.getTotalWriteBytes())});
                }
            }
        }
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Bytes Written", entry -> NumericUtils.humanReadableByteCount((double)Double.parseDouble(entry.toString())));
        return HoodiePrintHelper.print(HoodieTableHeaderFields.getTableHeaderWithExtraMetadata(), fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows, tempTableName);
    }

    @ShellMethod(key={"commits show"}, value="Show the commits")
    public String showCommits(@ShellOption(value={"--includeExtraMetadata"}, help="Include extra metadata", defaultValue="false") boolean includeExtraMetadata, @ShellOption(value={"--createView"}, help="view name to store output table", defaultValue="") String exportTableName, @ShellOption(value={"--limit"}, help="Limit commits", defaultValue="-1") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--partition"}, help="Partition value", defaultValue="__NULL__") String partition, @ShellOption(value={"--includeArchivedTimeline"}, help="Include archived commits as well", defaultValue="false") boolean includeArchivedTimeline) throws IOException {
        HoodieTimeline timeline = TimelineUtils.getTimeline((HoodieTableMetaClient)HoodieCLI.getTableMetaClient(), (boolean)includeArchivedTimeline);
        if (includeExtraMetadata) {
            return this.printCommitsWithMetadata(timeline, limit, sortByField, descending, headerOnly, exportTableName, partition);
        }
        return this.printCommits(timeline, limit, sortByField, descending, headerOnly, exportTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ShellMethod(key={"commits showarchived"}, value="Show the archived commits")
    public String showArchivedCommits(@ShellOption(value={"--includeExtraMetadata"}, help="Include extra metadata", defaultValue="false") boolean includeExtraMetadata, @ShellOption(value={"--createView"}, help="view name to store output table", defaultValue="") String exportTableName, @ShellOption(value={"--startTs"}, defaultValue="__NULL__", help="start time for commits, default: now - 10 days") String startTs, @ShellOption(value={"--endTs"}, defaultValue="__NULL__", help="end time for commits, default: now - 1 day") String endTs, @ShellOption(value={"--limit"}, help="Limit commits", defaultValue="-1") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--partition"}, help="Partition value", defaultValue="__NULL__") String partition) throws IOException {
        if (StringUtils.isNullOrEmpty((String)startTs)) {
            startTs = CommitUtil.getTimeDaysAgo(10);
        }
        if (StringUtils.isNullOrEmpty((String)endTs)) {
            endTs = CommitUtil.getTimeDaysAgo(1);
        }
        HoodieArchivedTimeline archivedTimeline = HoodieCLI.getTableMetaClient().getArchivedTimeline();
        try {
            archivedTimeline.loadInstantDetailsInMemory(startTs, endTs);
            HoodieTimeline timelineRange = archivedTimeline.findInstantsInRange(startTs, endTs);
            if (includeExtraMetadata) {
                String string = this.printCommitsWithMetadata(timelineRange, limit, sortByField, descending, headerOnly, exportTableName, partition);
                return string;
            }
            String string = this.printCommits(timelineRange, limit, sortByField, descending, headerOnly, exportTableName);
            return string;
        }
        finally {
            archivedTimeline.clearInstantDetailsFromMemory(startTs, endTs);
        }
    }

    @ShellMethod(key={"commit showpartitions"}, value="Show partition level details of a commit")
    public String showCommitPartitions(@ShellOption(value={"--createView"}, help="view name to store output table", defaultValue="") String exportTableName, @ShellOption(value={"--commit"}, help="Commit to show") String instantTime, @ShellOption(value={"--limit"}, help="Limit commits", defaultValue="-1") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--includeArchivedTimeline"}, help="Include archived commits as well", defaultValue="false") boolean includeArchivedTimeline) throws Exception {
        Option<HoodieInstant> hoodieInstantOption;
        HoodieTimeline defaultTimeline = TimelineUtils.getTimeline((HoodieTableMetaClient)HoodieCLI.getTableMetaClient(), (boolean)includeArchivedTimeline);
        HoodieTimeline timeline = defaultTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption = this.getCommitForInstant(timeline, instantTime));
        if (!commitMetadataOptional.isPresent()) {
            return "Commit " + instantTime + " not found in Commits " + timeline;
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (Map.Entry entry2 : meta.getPartitionToWriteStats().entrySet()) {
            String action = ((HoodieInstant)hoodieInstantOption.get()).getAction();
            String path = (String)entry2.getKey();
            List stats = (List)entry2.getValue();
            long totalFilesAdded = 0L;
            long totalFilesUpdated = 0L;
            long totalRecordsUpdated = 0L;
            long totalRecordsInserted = 0L;
            long totalBytesWritten = 0L;
            long totalWriteErrors = 0L;
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit().equals("null")) {
                    ++totalFilesAdded;
                } else {
                    ++totalFilesUpdated;
                    totalRecordsUpdated += stat.getNumUpdateWrites();
                }
                totalRecordsInserted += stat.getNumInserts();
                totalBytesWritten += stat.getTotalWriteBytes();
                totalWriteErrors += stat.getTotalWriteErrors();
            }
            rows.add(new Comparable[]{action, path, Long.valueOf(totalFilesAdded), Long.valueOf(totalFilesUpdated), Long.valueOf(totalRecordsInserted), Long.valueOf(totalRecordsUpdated), Long.valueOf(totalBytesWritten), Long.valueOf(totalWriteErrors)});
        }
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Bytes Written", entry -> NumericUtils.humanReadableByteCount((double)Long.parseLong(entry.toString())));
        TableHeader header = new TableHeader().addTableHeaderField("Action").addTableHeaderField("Partition Path").addTableHeaderField("Total Files Added").addTableHeaderField("Total Files Updated").addTableHeaderField("Total Records Inserted").addTableHeaderField("Total Records Updated").addTableHeaderField("Total Bytes Written").addTableHeaderField("Total Errors");
        return HoodiePrintHelper.print(header, fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows, exportTableName);
    }

    @ShellMethod(key={"commit show_write_stats"}, value="Show write stats of a commit")
    public String showWriteStats(@ShellOption(value={"--createView"}, help="view name to store output table", defaultValue="") String exportTableName, @ShellOption(value={"--commit"}, help="Commit to show") String instantTime, @ShellOption(value={"--limit"}, help="Limit commits", defaultValue="-1") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--includeArchivedTimeline"}, help="Include archived commits as well", defaultValue="false") boolean includeArchivedTimeline) throws Exception {
        Option<HoodieInstant> hoodieInstantOption;
        HoodieTimeline defaultTimeline = TimelineUtils.getTimeline((HoodieTableMetaClient)HoodieCLI.getTableMetaClient(), (boolean)includeArchivedTimeline);
        HoodieTimeline timeline = defaultTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption = this.getCommitForInstant(timeline, instantTime));
        if (!commitMetadataOptional.isPresent()) {
            return "Commit " + instantTime + " not found in Commits " + timeline;
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        String action = ((HoodieInstant)hoodieInstantOption.get()).getAction();
        long recordsWritten = meta.fetchTotalRecordsWritten();
        long bytesWritten = meta.fetchTotalBytesWritten();
        long avgRecSize = (long)Math.ceil(1.0 * (double)bytesWritten / (double)recordsWritten);
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        rows.add(new Comparable[]{action, Long.valueOf(bytesWritten), Long.valueOf(recordsWritten), Long.valueOf(avgRecSize)});
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Bytes Written", entry -> NumericUtils.humanReadableByteCount((double)Long.parseLong(entry.toString())));
        TableHeader header = new TableHeader().addTableHeaderField("Action").addTableHeaderField("Total Bytes Written for entire commit").addTableHeaderField("Total Records Written for entire commit").addTableHeaderField("Avg record size for entire commit");
        return HoodiePrintHelper.print(header, fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows, exportTableName);
    }

    @ShellMethod(key={"commit showfiles"}, value="Show file level details of a commit")
    public String showCommitFiles(@ShellOption(value={"--createView"}, help="view name to store output table", defaultValue="") String exportTableName, @ShellOption(value={"--commit"}, help="Commit to show") String instantTime, @ShellOption(value={"--limit"}, help="Limit commits", defaultValue="-1") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--includeArchivedTimeline"}, help="Include archived commits as well", defaultValue="false") boolean includeArchivedTimeline) throws Exception {
        Option<HoodieInstant> hoodieInstantOption;
        HoodieTimeline defaultTimeline = TimelineUtils.getTimeline((HoodieTableMetaClient)HoodieCLI.getTableMetaClient(), (boolean)includeArchivedTimeline);
        HoodieTimeline timeline = defaultTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption = this.getCommitForInstant(timeline, instantTime));
        if (!commitMetadataOptional.isPresent()) {
            return "Commit " + instantTime + " not found in Commits " + timeline;
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (Map.Entry entry : meta.getPartitionToWriteStats().entrySet()) {
            String action = ((HoodieInstant)hoodieInstantOption.get()).getAction();
            String path = (String)entry.getKey();
            List stats = (List)entry.getValue();
            for (HoodieWriteStat stat : stats) {
                rows.add(new Comparable[]{action, path, stat.getFileId(), stat.getPrevCommit(), Long.valueOf(stat.getNumUpdateWrites()), Long.valueOf(stat.getNumWrites()), Long.valueOf(stat.getTotalWriteBytes()), Long.valueOf(stat.getTotalWriteErrors()), Long.valueOf(stat.getFileSizeInBytes())});
            }
        }
        TableHeader header = new TableHeader().addTableHeaderField("Action").addTableHeaderField("Partition Path").addTableHeaderField("FileId").addTableHeaderField("Previous Commit").addTableHeaderField("Total Records Updated").addTableHeaderField("Total Records Written").addTableHeaderField("Total Bytes Written").addTableHeaderField("Total Errors").addTableHeaderField("File Size");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows, exportTableName);
    }

    @ShellMethod(key={"commits compare"}, value="Compare commits with another Hoodie table")
    public String compareCommits(@ShellOption(value={"--path"}, help="Path of the table to compare to") String path) {
        String sourceLatestCommit;
        HoodieTableMetaClient source = HoodieCLI.getTableMetaClient();
        HoodieTableMetaClient target = HoodieTableMetaClient.builder().setConf(HoodieCLI.conf.newInstance()).setBasePath(path).build();
        HoodieTimeline targetTimeline = target.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        HoodieTimeline sourceTimeline = source.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        String targetLatestCommit = targetTimeline.getInstantsAsStream().iterator().hasNext() ? ((HoodieInstant)targetTimeline.lastInstant().get()).requestedTime() : "0";
        String string = sourceLatestCommit = sourceTimeline.getInstantsAsStream().iterator().hasNext() ? ((HoodieInstant)sourceTimeline.lastInstant().get()).requestedTime() : "0";
        if (sourceLatestCommit != null && InstantComparison.compareTimestamps((String)targetLatestCommit, (BiPredicate)InstantComparison.GREATER_THAN, (String)sourceLatestCommit)) {
            List commitsToCatchup = targetTimeline.findInstantsAfter(sourceLatestCommit, Integer.MAX_VALUE).getInstantsAsStream().map(HoodieInstant::requestedTime).collect(Collectors.toList());
            return "Source " + source.getTableConfig().getTableName() + " is behind by " + commitsToCatchup.size() + " commits. Commits to catch up - " + commitsToCatchup;
        }
        List commitsToCatchup = sourceTimeline.findInstantsAfter(targetLatestCommit, Integer.MAX_VALUE).getInstantsAsStream().map(HoodieInstant::requestedTime).collect(Collectors.toList());
        return "Source " + source.getTableConfig().getTableName() + " is ahead by " + commitsToCatchup.size() + " commits. Commits to catch up - " + commitsToCatchup;
    }

    @ShellMethod(key={"commits sync"}, value="Sync commits with another Hoodie table")
    public String syncCommits(@ShellOption(value={"--path"}, help="Path of the table to sync to") String path) {
        HoodieCLI.syncTableMetadata = HoodieTableMetaClient.builder().setConf(HoodieCLI.conf.newInstance()).setBasePath(path).build();
        HoodieCLI.state = HoodieCLI.CLIState.SYNC;
        return "Load sync state between " + HoodieCLI.getTableMetaClient().getTableConfig().getTableName() + " and " + HoodieCLI.syncTableMetadata.getTableConfig().getTableName();
    }

    private Option<HoodieInstant> getCommitForInstant(HoodieTimeline timeline, String instantTime) {
        List<HoodieInstant> instants = Arrays.asList(HoodieCLI.getTableMetaClient().createNewInstant(HoodieInstant.State.COMPLETED, "commit", instantTime), HoodieCLI.getTableMetaClient().createNewInstant(HoodieInstant.State.COMPLETED, "replacecommit", instantTime), HoodieCLI.getTableMetaClient().createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", instantTime));
        return Option.fromJavaOptional(instants.stream().filter(arg_0 -> ((HoodieTimeline)timeline).containsInstant(arg_0)).findAny());
    }

    private Option<HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTimeline timeline, Option<HoodieInstant> hoodieInstant) throws IOException {
        if (hoodieInstant.isPresent()) {
            return Option.of((Object)TimelineUtils.getCommitMetadata((HoodieInstant)((HoodieInstant)hoodieInstant.get()), (HoodieTimeline)timeline));
        }
        return Option.empty();
    }
}

