/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class ExportCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ExportCommand.class);

    @ShellMethod(key={"export instants"}, value="Export Instants and their metadata from the Timeline")
    public String exportInstants(@ShellOption(value={"--limit"}, help="Limit Instants", defaultValue="-1") Integer limit, @ShellOption(value={"--actions"}, help="Comma separated list of Instant actions to export", defaultValue="clean,commit,deltacommit,rollback,savepoint,restore") String filter, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--localFolder"}, help="Local Folder to export to") String localFolder) throws Exception {
        StoragePath basePath = HoodieCLI.getTableMetaClient().getBasePath();
        StoragePath archivePath = HoodieCLI.getTableMetaClient().getArchivePath();
        HashSet<String> actionSet = new HashSet<String>(Arrays.asList(filter.split(",")));
        int numExports = limit == -1 ? Integer.MAX_VALUE : limit;
        int numCopied = 0;
        if (!new File(localFolder).isDirectory()) {
            throw new HoodieException(localFolder + " is not a valid local directory");
        }
        HoodieTimeline timeline = HoodieCLI.getTableMetaClient().getActiveTimeline().filterCompletedInstants().filter(i -> actionSet.contains(i.getAction()));
        List nonArchivedInstants = timeline.getInstants();
        List pathInfoList = HoodieStorageUtils.getStorage((StoragePath)basePath, HoodieCLI.conf).globEntries(archivePath);
        List<StoragePathInfo> archivedPathInfoList = pathInfoList.stream().sorted((f1, f2) -> (int)(f1.getModificationTime() - f2.getModificationTime())).collect(Collectors.toList());
        if (descending) {
            Collections.reverse(nonArchivedInstants);
            numCopied = this.copyNonArchivedInstants(nonArchivedInstants, numExports, localFolder);
            if (numCopied < numExports) {
                Collections.reverse(archivedPathInfoList);
                numCopied += this.copyArchivedInstants(archivedPathInfoList, actionSet, numExports - numCopied, localFolder);
            }
        } else {
            numCopied = this.copyArchivedInstants(archivedPathInfoList, actionSet, numExports, localFolder);
            if (numCopied < numExports) {
                numCopied += this.copyNonArchivedInstants(nonArchivedInstants, numExports - numCopied, localFolder);
            }
        }
        return "Exported " + numCopied + " Instants to " + localFolder;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int copyArchivedInstants(List<StoragePathInfo> pathInfoList, Set<String> actionSet, int limit, String localFolder) throws Exception {
        int copyCount = 0;
        HoodieStorage storage = HoodieStorageUtils.getStorage((StoragePath)HoodieCLI.getTableMetaClient().getBasePath(), HoodieCLI.conf);
        Iterator<StoragePathInfo> iterator = pathInfoList.iterator();
        block32: while (iterator.hasNext()) {
            StoragePathInfo pathInfo = iterator.next();
            HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((HoodieStorage)storage, (HoodieLogFile)new HoodieLogFile(pathInfo.getPath()), (Schema)HoodieArchivedMetaEntry.getClassSchema());
            Throwable throwable = null;
            try {
                Throwable throwable2;
                ClosableIterator recordItr;
                while (true) {
                    block38: {
                        if (!reader.hasNext() || copyCount++ >= limit) continue block32;
                        HoodieAvroDataBlock blk = (HoodieAvroDataBlock)reader.next();
                        recordItr = blk.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                        throwable2 = null;
                        while (recordItr.hasNext()) {
                            IndexedRecord ir = (IndexedRecord)((HoodieRecord)recordItr.next()).getData();
                            HoodieArchivedMetaEntry archiveEntryRecord = (HoodieArchivedMetaEntry)SpecificData.get().deepCopy(HoodieArchivedMetaEntry.SCHEMA$, (Object)ir);
                            String action = archiveEntryRecord.get("actionType").toString();
                            if (!actionSet.contains(action)) continue;
                            HoodieCleanMetadata metadata = null;
                            switch (action) {
                                case "clean": {
                                    metadata = archiveEntryRecord.getHoodieCleanMetadata();
                                    break;
                                }
                                case "commit": 
                                case "deltacommit": {
                                    metadata = archiveEntryRecord.getHoodieCommitMetadata();
                                    break;
                                }
                                case "rollback": {
                                    metadata = archiveEntryRecord.getHoodieRollbackMetadata();
                                    break;
                                }
                                case "savepoint": {
                                    metadata = archiveEntryRecord.getHoodieSavePointMetadata();
                                    break;
                                }
                                case "compaction": {
                                    metadata = archiveEntryRecord.getHoodieCompactionMetadata();
                                    break;
                                }
                                default: {
                                    throw new HoodieException("Unknown type of action " + action);
                                }
                            }
                            String instantTime = archiveEntryRecord.get("commitTime").toString();
                            if (metadata == null) {
                                LOG.error("Could not load metadata for action " + action + " at instant time " + instantTime);
                                continue;
                            }
                            String outPath = localFolder + "/" + instantTime + "." + action;
                            this.writeToFile(outPath, HoodieAvroUtils.avroToJson((GenericRecord)metadata, (boolean)true));
                        }
                        if (recordItr == null) continue;
                        if (throwable2 == null) break block38;
                        try {
                            recordItr.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    recordItr.close();
                }
                catch (Throwable throwable4) {
                    try {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (recordItr == null) throw throwable5;
                        if (throwable2 != null) {
                            try {
                                recordItr.close();
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                                throw throwable5;
                            }
                        }
                        recordItr.close();
                        throw throwable5;
                    }
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    continue;
                }
                reader.close();
            }
        }
        return copyCount;
    }

    private int copyNonArchivedInstants(List<HoodieInstant> instants, int limit, String localFolder) throws Exception {
        int copyCount = 0;
        if (instants.isEmpty()) {
            return copyCount;
        }
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        InstantFileNameGenerator instantFileNameGenerator = metaClient.getInstantFileNameGenerator();
        HoodieActiveTimeline timeline = metaClient.getActiveTimeline();
        for (HoodieInstant instant : instants) {
            String localPath = localFolder + "/" + instantFileNameGenerator.getFileName(instant);
            byte[] data = null;
            switch (instant.getAction()) {
                case "clean": {
                    HoodieCleanMetadata metadata = timeline.readCleanMetadata(instant);
                    data = HoodieAvroUtils.avroToJson((GenericRecord)metadata, (boolean)true);
                    break;
                }
                case "deltacommit": 
                case "commit": 
                case "compaction": {
                    data = (byte[])timeline.getInstantDetails(instant).get();
                    break;
                }
                case "rollback": {
                    HoodieCleanMetadata metadata = timeline.readRollbackMetadata(instant);
                    data = HoodieAvroUtils.avroToJson((GenericRecord)metadata, (boolean)true);
                    break;
                }
                case "savepoint": {
                    HoodieCleanMetadata metadata = timeline.readSavepointMetadata(instant);
                    data = HoodieAvroUtils.avroToJson((GenericRecord)metadata, (boolean)true);
                    break;
                }
                default: {
                    throw new HoodieException("Unknown type of action " + instant.getAction());
                }
            }
            if (data == null) continue;
            this.writeToFile(localPath, data);
            ++copyCount;
        }
        return copyCount;
    }

    private void writeToFile(String path, byte[] data) throws Exception {
        try (FileOutputStream writer = new FileOutputStream(path);){
            writer.write(data);
        }
    }
}

