/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.utils.CommitUtil;
import org.apache.hudi.cli.utils.HiveUtil;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.exception.HoodieException;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class HoodieSyncValidateCommand {
    @ShellMethod(key={"sync validate"}, value="Validate the sync by counting the number of records")
    public String validateSync(@ShellOption(value={"--mode"}, defaultValue="complete", help="Check mode") String mode, @ShellOption(value={"--sourceDb"}, defaultValue="rawdata", help="source database") String srcDb, @ShellOption(value={"--targetDb"}, defaultValue="dwh_hoodie", help="target database") String tgtDb, @ShellOption(value={"--partitionCount"}, defaultValue="5", help="total number of recent partitions to validate") int partitionCount, @ShellOption(value={"--hiveServerUrl"}, help="hiveServerURL to connect to") String hiveServerUrl, @ShellOption(value={"--hiveUser"}, defaultValue="", help="hive username to connect to") String hiveUser, @ShellOption(value={"--hivePass"}, defaultValue="", help="hive password to connect to") String hivePass) throws Exception {
        String sourceLatestCommit;
        if (HoodieCLI.syncTableMetadata == null) {
            throw new HoodieException("Sync validate request target table not null.");
        }
        HoodieTableMetaClient target = HoodieCLI.syncTableMetadata;
        HoodieTimeline targetTimeline = target.getActiveTimeline().getCommitsTimeline();
        HoodieTableMetaClient source = HoodieCLI.getTableMetaClient();
        HoodieTimeline sourceTimeline = source.getActiveTimeline().getCommitsTimeline();
        long sourceCount = 0L;
        long targetCount = 0L;
        if ("complete".equals(mode)) {
            sourceCount = HiveUtil.countRecords(hiveServerUrl, source, srcDb, hiveUser, hivePass);
            targetCount = HiveUtil.countRecords(hiveServerUrl, target, tgtDb, hiveUser, hivePass);
        } else if ("latestPartitions".equals(mode)) {
            sourceCount = HiveUtil.countRecords(hiveServerUrl, source, srcDb, partitionCount, hiveUser, hivePass);
            targetCount = HiveUtil.countRecords(hiveServerUrl, target, tgtDb, partitionCount, hiveUser, hivePass);
        }
        String targetLatestCommit = targetTimeline.getInstants().iterator().hasNext() ? ((HoodieInstant)targetTimeline.lastInstant().get()).requestedTime() : "0";
        String string = sourceLatestCommit = sourceTimeline.getInstants().iterator().hasNext() ? ((HoodieInstant)sourceTimeline.lastInstant().get()).requestedTime() : "0";
        if (sourceLatestCommit != null && InstantComparison.compareTimestamps((String)targetLatestCommit, (BiPredicate)InstantComparison.GREATER_THAN, (String)sourceLatestCommit)) {
            return this.getString(target, targetTimeline, source, sourceCount, targetCount, sourceLatestCommit);
        }
        return this.getString(source, sourceTimeline, target, targetCount, sourceCount, targetLatestCommit);
    }

    private String getString(HoodieTableMetaClient target, HoodieTimeline targetTimeline, HoodieTableMetaClient source, long sourceCount, long targetCount, String sourceLatestCommit) throws IOException {
        List commitsToCatchup = targetTimeline.findInstantsAfter(sourceLatestCommit, Integer.MAX_VALUE).getInstants();
        if (commitsToCatchup.isEmpty()) {
            return "Count difference now is (count(" + target.getTableConfig().getTableName() + ") - count(" + source.getTableConfig().getTableName() + ") == " + (targetCount - sourceCount);
        }
        long newInserts = CommitUtil.countNewRecords(target, commitsToCatchup.stream().map(HoodieInstant::requestedTime).collect(Collectors.toList()));
        return "Count difference now is (count(" + target.getTableConfig().getTableName() + ") - count(" + source.getTableConfig().getTableName() + ") == " + (targetCount - sourceCount) + ". Catch up count is " + newInserts;
    }
}

