/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.avro.AvroRuntimeException;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.sql.hudi.DeDupeType;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import scala.collection.JavaConverters;
import scala.collection.Map;

@ShellComponent
public class RepairsCommand {
    private static final Logger LOG = LoggerFactory.getLogger(RepairsCommand.class);
    public static final String DEDUPLICATE_RETURN_PREFIX = "Deduplicated files placed in:  ";

    @ShellMethod(key={"repair deduplicate"}, value="De-duplicate a partition path contains duplicates & produce repaired files to replace with")
    public String deduplicate(@ShellOption(value={"--duplicatedPartitionPath"}, defaultValue="", help="Partition Path containing the duplicates") String duplicatedPartitionPath, @ShellOption(value={"--repairedOutputPath"}, help="Location to place the repaired files") String repairedOutputPath, @ShellOption(value={"--sparkProperties"}, help="Spark Properties File Path", defaultValue="") String sparkPropertiesPath, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master") String master, @ShellOption(value={"--sparkMemory"}, defaultValue="4G", help="Spark executor memory") String sparkMemory, @ShellOption(value={"--dryrun"}, help="Should we actually remove duplicates or just run and store result to repairedOutputPath", defaultValue="true") boolean dryRun, @ShellOption(value={"--dedupeType"}, help="Valid values are - insert_type, update_type and upsert_type", defaultValue="insert_type") String dedupeType) throws Exception {
        if (!DeDupeType.values().contains(DeDupeType.withName((String)dedupeType))) {
            throw new IllegalArgumentException("Please provide valid dedupe type!");
        }
        if (StringUtils.isNullOrEmpty((String)sparkPropertiesPath)) {
            sparkPropertiesPath = Utils.getDefaultPropertiesFile((Map)((Map)JavaConverters.mapAsScalaMapConverter(System.getenv()).asScala()));
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        SparkMain.addAppArgs(sparkLauncher, SparkMain.SparkCommand.DEDUPLICATE, master, sparkMemory, duplicatedPartitionPath, repairedOutputPath, HoodieCLI.basePath, String.valueOf(dryRun), dedupeType);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Deduplication failed!";
        }
        if (dryRun) {
            return DEDUPLICATE_RETURN_PREFIX + repairedOutputPath;
        }
        return DEDUPLICATE_RETURN_PREFIX + duplicatedPartitionPath;
    }

    @ShellMethod(key={"repair addpartitionmeta"}, value="Add partition metadata to a table, if not present")
    public String addPartitionMeta(@ShellOption(value={"--dryrun"}, help="Should we actually add or just print what would be done", defaultValue="true") boolean dryRun) throws IOException {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        String latestCommit = ((HoodieInstant)client.getActiveTimeline().getCommitAndReplaceTimeline().lastInstant().get()).requestedTime();
        List partitionPaths = FSUtils.getAllPartitionFoldersThreeLevelsDown((HoodieStorage)HoodieCLI.storage, (String)HoodieCLI.basePath);
        StoragePath basePath = client.getBasePath();
        String[][] rows = new String[partitionPaths.size()][];
        int ind = 0;
        for (String partition : partitionPaths) {
            StoragePath partitionPath = FSUtils.constructAbsolutePath((StoragePath)basePath, (String)partition);
            String[] row = new String[]{partition, "Yes", "None"};
            if (!HoodiePartitionMetadata.hasPartitionMetadata((HoodieStorage)HoodieCLI.storage, (StoragePath)partitionPath)) {
                row[1] = "No";
                if (!dryRun) {
                    HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(HoodieCLI.storage, latestCommit, basePath, partitionPath, client.getTableConfig().getPartitionMetafileFormat());
                    partitionMetadata.trySave();
                    row[2] = "Repaired";
                }
            }
            rows[ind++] = row;
        }
        return HoodiePrintHelper.print(new String[]{"Partition Path", "Metadata Present?", "Action"}, rows);
    }

    @ShellMethod(key={"repair overwrite-hoodie-props"}, value="Overwrite hoodie.properties with provided file. Risky operation. Proceed with caution!")
    public String overwriteHoodieProperties(@ShellOption(value={"--new-props-file"}, help="Path to a properties file on local filesystem to overwrite the table's hoodie.properties with") String overwriteFilePath) throws IOException {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        Properties newProps = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(overwriteFilePath);){
            newProps.load(fileInputStream);
        }
        java.util.Map oldProps = client.getTableConfig().propsMap();
        if (oldProps.containsKey(HoodieTableConfig.INITIAL_VERSION.key())) {
            newProps.put(HoodieTableConfig.INITIAL_VERSION.key(), oldProps.get(HoodieTableConfig.INITIAL_VERSION.key()));
        }
        HoodieTableConfig.create((HoodieStorage)client.getStorage(), (StoragePath)client.getMetaPath(), (Properties)newProps);
        newProps = HoodieTableMetaClient.reload((HoodieTableMetaClient)HoodieCLI.getTableMetaClient()).getTableConfig().getProps();
        TreeSet allPropKeys = new TreeSet();
        allPropKeys.addAll(newProps.keySet().stream().map(Object::toString).collect(Collectors.toSet()));
        allPropKeys.addAll(oldProps.keySet());
        String[][] rows = new String[allPropKeys.size()][];
        int ind = 0;
        for (String propKey : allPropKeys) {
            String[] row = new String[]{propKey, oldProps.getOrDefault(propKey, "null"), newProps.getOrDefault((Object)propKey, "null").toString()};
            rows[ind++] = row;
        }
        return HoodiePrintHelper.print(new String[]{"Property", "Old Value", "New Value"}, rows);
    }

    @ShellMethod(key={"repair corrupted clean files"}, value="repair corrupted clean files")
    public void removeCorruptedPendingCleanAction() {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        HoodieTimeline cleanerTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline().getCleanerTimeline();
        LOG.info("Inspecting pending clean metadata in timeline for corrupted files");
        cleanerTimeline.filterInflightsAndRequested().getInstants().forEach(instant -> {
            try {
                CleanerUtils.getCleanerPlan((HoodieTableMetaClient)client, (HoodieInstant)instant);
            }
            catch (AvroRuntimeException e) {
                LOG.warn("Corruption found. Trying to remove corrupted clean instant file: " + instant);
                TimelineUtils.deleteInstantFile((HoodieStorage)client.getStorage(), (StoragePath)client.getTimelinePath(), (HoodieInstant)instant, (InstantFileNameGenerator)client.getInstantFileNameGenerator());
            }
            catch (IOException ioe) {
                if (ioe.getMessage().contains("Not an Avro data file")) {
                    LOG.warn("Corruption found. Trying to remove corrupted clean instant file: " + instant);
                    TimelineUtils.deleteInstantFile((HoodieStorage)client.getStorage(), (StoragePath)client.getTimelinePath(), (HoodieInstant)instant, (InstantFileNameGenerator)client.getInstantFileNameGenerator());
                }
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
        });
    }

    @ShellMethod(key={"repair show empty commit metadata"}, value="show failed commits")
    public void showFailedCommits() {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        activeTimeline.filterCompletedInstants().getInstantsAsStream().filter(arg_0 -> ((HoodieActiveTimeline)activeTimeline).isEmpty(arg_0)).forEach(hoodieInstant -> LOG.warn("Empty Commit: " + hoodieInstant.toString()));
    }

    @ShellMethod(key={"repair migrate-partition-meta"}, value="Migrate all partition meta file currently stored in text format to be stored in base file format. See HoodieTableConfig#PARTITION_METAFILE_USE_DATA_FORMAT.")
    public String migratePartitionMeta(@ShellOption(value={"--dryrun"}, help="dry run without modifying anything.", defaultValue="true") boolean dryRun) throws IOException {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(HoodieCLI.conf);
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        List partitionPaths = FSUtils.getAllPartitionPaths((HoodieEngineContext)engineContext, (HoodieStorage)client.getStorage(), (StoragePath)client.getBasePath(), (boolean)false);
        StoragePath basePath = client.getBasePath();
        String[][] rows = new String[partitionPaths.size()][];
        int ind = 0;
        for (String partitionPath : partitionPaths) {
            StoragePath partition = FSUtils.constructAbsolutePath((StoragePath)client.getBasePath(), (String)partitionPath);
            Option textFormatFile = HoodiePartitionMetadata.textFormatMetaPathIfExists((HoodieStorage)HoodieCLI.storage, (StoragePath)partition);
            Option baseFormatFile = HoodiePartitionMetadata.baseFormatMetaPathIfExists((HoodieStorage)HoodieCLI.storage, (StoragePath)partition);
            String latestCommit = ((HoodieInstant)client.getActiveTimeline().getCommitAndReplaceTimeline().lastInstant().get()).requestedTime();
            String[] row = new String[]{partitionPath, String.valueOf(textFormatFile.isPresent()), String.valueOf(baseFormatFile.isPresent()), textFormatFile.isPresent() ? "MIGRATE" : "NONE"};
            if (!dryRun) {
                if (!baseFormatFile.isPresent()) {
                    HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(HoodieCLI.storage, latestCommit, basePath, partition, Option.of((Object)client.getTableConfig().getBaseFileFormat()));
                    partitionMetadata.trySave();
                }
                textFormatFile.ifPresent(path -> {
                    try {
                        HoodieCLI.storage.deleteFile(path);
                    }
                    catch (IOException e) {
                        throw new HoodieIOException(e.getMessage(), e);
                    }
                });
                row[3] = "MIGRATED";
            }
            rows[ind++] = row;
        }
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.key(), "true");
        HoodieTableConfig.update((HoodieStorage)HoodieCLI.storage, (StoragePath)client.getMetaPath(), (Properties)props);
        return HoodiePrintHelper.print(new String[]{"Partition Path", "Text Metafile present ?", "Base Metafile present ?", "Action"}, rows);
    }

    @ShellMethod(key={"repair deprecated partition"}, value="Repair deprecated partition (\"default\"). Re-writes data from the deprecated partition into __HIVE_DEFAULT_PARTITION__")
    public String repairDeprecatePartition(@ShellOption(value={"--sparkProperties"}, help="Spark Properties File Path", defaultValue="") String sparkPropertiesPath, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master") String master, @ShellOption(value={"--sparkMemory"}, defaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        if (StringUtils.isNullOrEmpty((String)sparkPropertiesPath)) {
            sparkPropertiesPath = Utils.getDefaultPropertiesFile((Map)((Map)JavaConverters.mapAsScalaMapConverter(System.getenv()).asScala()));
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        SparkMain.addAppArgs(sparkLauncher, SparkMain.SparkCommand.REPAIR_DEPRECATED_PARTITION, master, sparkMemory, HoodieCLI.basePath);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Deduplication failed!";
        }
        return "Repair succeeded";
    }

    @ShellMethod(key={"rename partition"}, value="Rename partition. Usage: rename partition --oldPartition <oldPartition> --newPartition <newPartition>")
    public String renamePartition(@ShellOption(value={"--oldPartition"}, help="Partition value to be renamed") String oldPartition, @ShellOption(value={"--newPartition"}, help="New partition value after rename") String newPartition, @ShellOption(value={"--sparkProperties"}, help="Spark Properties File Path", defaultValue="") String sparkPropertiesPath, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master") String master, @ShellOption(value={"--sparkMemory"}, defaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        if (StringUtils.isNullOrEmpty((String)sparkPropertiesPath)) {
            sparkPropertiesPath = Utils.getDefaultPropertiesFile((Map)((Map)JavaConverters.mapAsScalaMapConverter(System.getenv()).asScala()));
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        SparkMain.addAppArgs(sparkLauncher, SparkMain.SparkCommand.RENAME_PARTITION, master, sparkMemory, HoodieCLI.basePath, oldPartition, newPartition);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "rename partition failed!";
        }
        return "rename partition succeeded";
    }
}

