/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class SparkEnvCommand {
    public static Map<String, String> env = new HashMap<String, String>();

    @ShellMethod(key={"set"}, value="Set spark launcher env to cli")
    public void setEnv(@ShellOption(value={"--conf"}, help="Env config to be set") String confMap) {
        String[] map = confMap.split("=");
        if (map.length != 2) {
            throw new IllegalArgumentException("Illegal set parameter, please use like [set --conf SPARK_HOME=/usr/etc/spark]");
        }
        env.put(map[0].trim(), map[1].trim());
        System.setProperty(map[0].trim(), map[1].trim());
    }

    @ShellMethod(key={"show envs all"}, value="Show spark launcher envs")
    public String showAllEnv() {
        String[][] rows = new String[env.size()][2];
        int i = 0;
        for (Map.Entry<String, String> entry : env.entrySet()) {
            rows[i] = new String[]{entry.getKey(), entry.getValue()};
            ++i;
        }
        return HoodiePrintHelper.print(new String[]{"key", "value"}, rows);
    }

    @ShellMethod(key={"show env"}, value="Show spark launcher env by key")
    public String showEnvByKey(@ShellOption(value={"--key"}, help="Which env conf want to show") String key) {
        if (key == null || key.isEmpty()) {
            return this.showAllEnv();
        }
        return HoodiePrintHelper.print(new String[]{"key", "value"}, new String[][]{{key, env.getOrDefault(key, "")}});
    }
}

