/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.common.util.StringUtils;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class UtilsCommand {
    @ShellMethod(key={"utils loadClass"}, value="Load a class")
    public String loadClass(@ShellOption(value={"--class"}, help="Check mode") String clazz) {
        if (StringUtils.isNullOrEmpty((String)clazz)) {
            return "Class to be loaded can not be null!";
        }
        try {
            Class<?> klass = Class.forName(clazz);
            return klass.getProtectionDomain().getCodeSource().getLocation().toExternalForm();
        }
        catch (ClassNotFoundException e) {
            return String.format("Class %s not found!", clazz);
        }
    }
}

