/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.utils;

import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.utils.CommitUtil;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;

public class CLIUtils {
    public static HoodieTimeline getTimelineInRange(String startTs, String endTs, boolean includeArchivedTimeline) {
        if (StringUtils.isNullOrEmpty((String)startTs)) {
            startTs = CommitUtil.getTimeDaysAgo(10);
        }
        if (StringUtils.isNullOrEmpty((String)endTs)) {
            endTs = CommitUtil.getTimeDaysAgo(1);
        }
        ValidationUtils.checkArgument((boolean)StringUtils.nonEmpty((String)startTs), (String)"startTs is null or empty");
        ValidationUtils.checkArgument((boolean)StringUtils.nonEmpty((String)endTs), (String)"endTs is null or empty");
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        if (includeArchivedTimeline) {
            HoodieArchivedTimeline archivedTimeline = metaClient.getArchivedTimeline();
            archivedTimeline.loadInstantDetailsInMemory(startTs, endTs);
            return archivedTimeline.findInstantsInRange(startTs, endTs).mergeTimeline((HoodieTimeline)activeTimeline);
        }
        return activeTimeline;
    }
}

