/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.callback.http;

import java.io.IOException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.hudi.callback.client.http.HoodieWriteCommitHttpCallbackClient;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestCallbackHttpClient {
    @Mock
    AppenderSkeleton appender;
    @Captor
    ArgumentCaptor<LoggingEvent> logCaptor;
    @Mock
    CloseableHttpClient httpClient;
    @Mock
    CloseableHttpResponse httpResponse;
    @Mock
    StatusLine statusLine;

    @AfterEach
    void resetMocks() {
        Mockito.reset((Object[])new Object[]{this.appender, this.httpClient, this.httpResponse, this.statusLine});
    }

    private void mockResponse(int statusCode) {
        Mockito.when((Object)this.statusLine.getStatusCode()).thenReturn((Object)statusCode);
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)this.statusLine);
        try {
            Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)this.httpResponse);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void sendPayloadShouldLogWhenRequestFailed() throws IOException {
        Logger.getRootLogger().addAppender((Appender)this.appender);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenThrow(IOException.class);
        HoodieWriteCommitHttpCallbackClient hoodieWriteCommitCallBackHttpClient = new HoodieWriteCommitHttpCallbackClient("fake_api_key", "fake_url", this.httpClient);
        hoodieWriteCommitCallBackHttpClient.send("{}");
        ((AppenderSkeleton)Mockito.verify((Object)this.appender)).doAppend((LoggingEvent)this.logCaptor.capture());
        Assertions.assertEquals((Object)"Failed to send callback.", (Object)((LoggingEvent)this.logCaptor.getValue()).getRenderedMessage());
        Assertions.assertEquals((Object)Level.WARN, (Object)((LoggingEvent)this.logCaptor.getValue()).getLevel());
    }

    @Test
    public void sendPayloadShouldLogUnsuccessfulSending() {
        Logger.getRootLogger().addAppender((Appender)this.appender);
        this.mockResponse(401);
        Mockito.when((Object)this.httpResponse.toString()).thenReturn((Object)"unauthorized");
        HoodieWriteCommitHttpCallbackClient hoodieWriteCommitCallBackHttpClient = new HoodieWriteCommitHttpCallbackClient("fake_api_key", "fake_url", this.httpClient);
        hoodieWriteCommitCallBackHttpClient.send("{}");
        ((AppenderSkeleton)Mockito.verify((Object)this.appender)).doAppend((LoggingEvent)this.logCaptor.capture());
        Assertions.assertEquals((Object)"Failed to send callback message. Response was unauthorized", (Object)((LoggingEvent)this.logCaptor.getValue()).getRenderedMessage());
        Assertions.assertEquals((Object)Level.WARN, (Object)((LoggingEvent)this.logCaptor.getValue()).getLevel());
    }

    @Test
    public void sendPayloadShouldLogSuccessfulSending() {
        Logger.getRootLogger().addAppender((Appender)this.appender);
        this.mockResponse(202);
        HoodieWriteCommitHttpCallbackClient hoodieWriteCommitCallBackHttpClient = new HoodieWriteCommitHttpCallbackClient("fake_api_key", "fake_url", this.httpClient);
        hoodieWriteCommitCallBackHttpClient.send("{}");
        ((AppenderSkeleton)Mockito.verify((Object)this.appender)).doAppend((LoggingEvent)this.logCaptor.capture());
        Assertions.assertTrue((boolean)((LoggingEvent)this.logCaptor.getValue()).getRenderedMessage().startsWith("Sent Callback data"));
        Assertions.assertEquals((Object)Level.INFO, (Object)((LoggingEvent)this.logCaptor.getValue()).getLevel());
    }
}

