/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieLockException;

public class FileSystemBasedLockProviderTestClass
implements LockProvider<String>,
Serializable {
    private static final String LOCK_NAME = "acquired";
    private String lockPath;
    private transient FileSystem fs;
    protected LockConfiguration lockConfiguration;

    public FileSystemBasedLockProviderTestClass(LockConfiguration lockConfiguration, Configuration configuration) {
        this.lockConfiguration = lockConfiguration;
        this.lockPath = lockConfiguration.getConfig().getString("hoodie.write.lock.filesystem.path");
        this.fs = FSUtils.getFs((String)this.lockPath, (Configuration)configuration);
    }

    public void acquireLock() {
        try {
            this.fs.create(new Path(this.lockPath + "/" + LOCK_NAME), false).close();
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to acquire lock", e);
        }
    }

    public void close() {
        try {
            this.fs.delete(new Path(this.lockPath + "/" + LOCK_NAME), true);
        }
        catch (IOException e) {
            throw new HoodieLockException("Unable to release lock", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(long time, TimeUnit unit) {
        try {
            int numRetries = 0;
            while (this.fs.exists(new Path(this.lockPath + "/" + LOCK_NAME)) && numRetries <= this.lockConfiguration.getConfig().getInteger("hoodie.write.lock.num_retries")) {
                Thread.sleep(this.lockConfiguration.getConfig().getInteger("hoodie.write.lock.wait_time_ms_between_retry"));
            }
            String string = LOCK_NAME;
            synchronized (LOCK_NAME) {
                if (this.fs.exists(new Path(this.lockPath + "/" + LOCK_NAME))) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return false;
                }
                this.acquireLock();
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return true;
            }
        }
        catch (IOException | InterruptedException e) {
            throw new HoodieLockException("Failed to acquire lock", (Throwable)e);
        }
    }

    public void unlock() {
        try {
            if (this.fs.exists(new Path(this.lockPath + "/" + LOCK_NAME))) {
                this.fs.delete(new Path(this.lockPath + "/" + LOCK_NAME), true);
            }
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to delete lock on disk", io);
        }
    }

    public String getLock() {
        try {
            return this.fs.listStatus(new Path(this.lockPath))[0].getPath().toString();
        }
        catch (Exception e) {
            throw new HoodieLockException("Failed to retrieve lock status from lock path " + this.lockPath);
        }
    }
}

