/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.io.storage.HoodieHFileConfig;
import org.apache.hudi.io.storage.HoodieHFileReader;
import org.apache.hudi.io.storage.HoodieHFileWriter;
import org.apache.hudi.io.storage.TestHoodieOrcReaderWriter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TestHoodieHFileReaderWriter {
    @TempDir
    File tempDir;
    private Path filePath;

    @BeforeEach
    public void setup() throws IOException {
        this.filePath = new Path(this.tempDir.toString() + "tempFile.txt");
    }

    @AfterEach
    public void clearTempFile() {
        File file = new File(this.filePath.toString());
        if (file.exists()) {
            file.delete();
        }
    }

    private static Stream<Arguments> populateMetaFieldsAndTestAvroWithMeta() {
        return Arrays.stream(new Boolean[][]{{true, true}, {false, true}, {true, false}, {false, false}}).map(Arguments::of);
    }

    private HoodieHFileWriter createHFileWriter(Schema avroSchema, boolean populateMetaFields) throws Exception {
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-5, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        Configuration conf = new Configuration();
        TaskContextSupplier mockTaskContextSupplier = (TaskContextSupplier)Mockito.mock(TaskContextSupplier.class);
        Supplier partitionSupplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)mockTaskContextSupplier.getPartitionIdSupplier()).thenReturn((Object)partitionSupplier);
        Mockito.when(partitionSupplier.get()).thenReturn((Object)10);
        String instantTime = "000";
        HoodieHFileConfig hoodieHFileConfig = new HoodieHFileConfig(conf, Compression.Algorithm.GZ, 0x100000, 0x7800000L, false, false, true, filter, HoodieHFileConfig.HFILE_COMPARATOR);
        return new HoodieHFileWriter(instantTime, this.filePath, hoodieHFileConfig, avroSchema, mockTaskContextSupplier, populateMetaFields);
    }

    @ParameterizedTest
    @MethodSource(value={"populateMetaFieldsAndTestAvroWithMeta"})
    public void testWriteReadHFile(boolean populateMetaFields, boolean testAvroWithMeta) throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleSchemaWithMetaFields.avsc");
        HoodieHFileWriter writer = this.createHFileWriter(avroSchema, populateMetaFields);
        ArrayList<String> keys = new ArrayList<String>();
        HashMap<String, GenericData.Record> recordMap = new HashMap<String, GenericData.Record>();
        for (int i = 0; i < 100; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            String key = String.format("%s%04d", "key", i);
            record.put("_row_key", (Object)key);
            keys.add(key);
            record.put("time", (Object)Integer.toString(FileSystemTestUtils.RANDOM.nextInt()));
            record.put("number", (Object)i);
            if (testAvroWithMeta) {
                writer.writeAvroWithMetadata((IndexedRecord)record, new HoodieRecord(new HoodieKey((String)record.get("_row_key"), Integer.toString((Integer)record.get("number"))), (HoodieRecordPayload)new EmptyHoodieRecordPayload()));
            } else {
                writer.writeAvro(key, (IndexedRecord)record);
            }
            recordMap.put(key, record);
        }
        writer.close();
        Configuration conf = new Configuration();
        CacheConfig cacheConfig = new CacheConfig(conf);
        HoodieHFileReader hoodieHFileReader = new HoodieHFileReader(conf, this.filePath, cacheConfig, this.filePath.getFileSystem(conf));
        List records = hoodieHFileReader.readAllRecords();
        records.forEach(entry -> Assertions.assertEquals((Object)entry.getSecond(), recordMap.get(entry.getFirst())));
        hoodieHFileReader.close();
        for (int i = 0; i < 2; ++i) {
            int randomRowstoFetch = 5 + FileSystemTestUtils.RANDOM.nextInt(10);
            Set<String> rowsToFetch = this.getRandomKeys(randomRowstoFetch, keys);
            ArrayList<String> rowsList = new ArrayList<String>(rowsToFetch);
            Collections.sort(rowsList);
            hoodieHFileReader = new HoodieHFileReader(conf, this.filePath, cacheConfig, this.filePath.getFileSystem(conf));
            List result = hoodieHFileReader.readRecords(rowsList);
            Assertions.assertEquals((int)result.size(), (int)randomRowstoFetch);
            result.forEach(entry -> {
                Assertions.assertEquals((Object)entry.getSecond(), recordMap.get(entry.getFirst()));
                if (populateMetaFields && testAvroWithMeta) {
                    Assertions.assertNotNull((Object)((GenericRecord)entry.getSecond()).get("_hoodie_record_key"));
                } else {
                    Assertions.assertNull((Object)((GenericRecord)entry.getSecond()).get("_hoodie_record_key"));
                }
            });
            hoodieHFileReader.close();
        }
    }

    private Set<String> getRandomKeys(int count, List<String> keys) {
        HashSet<String> rowKeys = new HashSet<String>();
        int totalKeys = keys.size();
        while (rowKeys.size() < count) {
            int index = FileSystemTestUtils.RANDOM.nextInt(totalKeys);
            if (rowKeys.contains(index)) continue;
            rowKeys.add(keys.get(index));
        }
        return rowKeys;
    }
}

