/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.datadog;

import com.codahale.metrics.MetricRegistry;
import java.util.Arrays;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.apache.hudi.metrics.datadog.DatadogMetricsReporter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestDatadogMetricsReporter {
    @Mock
    HoodieWriteConfig config;
    @Mock
    MetricRegistry registry;

    @AfterEach
    void shutdownMetrics() {
        Metrics.shutdown();
    }

    @Test
    public void instantiationShouldFailWhenNoApiKey() {
        Mockito.when((Object)this.config.getDatadogApiKey()).thenReturn((Object)"");
        Throwable t = Assertions.assertThrows(IllegalStateException.class, () -> new DatadogMetricsReporter(this.config, this.registry));
        Assertions.assertEquals((Object)"Datadog cannot be initialized: API key is null or empty.", (Object)t.getMessage());
    }

    @Test
    public void instantiationShouldFailWhenNoMetricPrefix() {
        Mockito.when((Object)this.config.getDatadogApiKey()).thenReturn((Object)"foo");
        Mockito.when((Object)this.config.getDatadogMetricPrefix()).thenReturn((Object)"");
        Throwable t = Assertions.assertThrows(IllegalStateException.class, () -> new DatadogMetricsReporter(this.config, this.registry));
        Assertions.assertEquals((Object)"Datadog cannot be initialized: Metric prefix is null or empty.", (Object)t.getMessage());
    }

    @Test
    public void instantiationShouldSucceed() {
        Mockito.when((Object)this.config.getDatadogApiSite()).thenReturn((Object)DatadogHttpClient.ApiSite.EU);
        Mockito.when((Object)this.config.getDatadogApiKey()).thenReturn((Object)"foo");
        Mockito.when((Object)this.config.getDatadogApiKeySkipValidation()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getDatadogMetricPrefix()).thenReturn((Object)"bar");
        Mockito.when((Object)this.config.getDatadogMetricHost()).thenReturn((Object)"foo");
        Mockito.when((Object)this.config.getDatadogMetricTags()).thenReturn(Arrays.asList("baz", "foo"));
        Assertions.assertDoesNotThrow(() -> new DatadogMetricsReporter(this.config, this.registry));
    }
}

