/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.datadog;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.apache.hudi.metrics.datadog.DatadogReporter;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestDatadogReporter {
    @Mock
    AppenderSkeleton appender;
    @Captor
    ArgumentCaptor<LoggingEvent> logCaptor;
    @Mock
    MetricRegistry registry;
    @Mock
    DatadogHttpClient client;

    @AfterEach
    void resetMocks() {
        Mockito.reset((Object[])new Object[]{this.appender, this.registry, this.client});
    }

    @Test
    public void stopShouldCloseEnclosedClient() throws IOException {
        new DatadogReporter(this.registry, this.client, "foo", Option.empty(), Option.empty(), MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS).stop();
        ((DatadogHttpClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void stopShouldLogWhenEnclosedClientFailToClose() throws IOException {
        Logger.getRootLogger().addAppender((Appender)this.appender);
        ((DatadogHttpClient)Mockito.doThrow(IOException.class).when((Object)this.client)).close();
        new DatadogReporter(this.registry, this.client, "foo", Option.empty(), Option.empty(), MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS).stop();
        ((AppenderSkeleton)Mockito.verify((Object)this.appender)).doAppend((LoggingEvent)this.logCaptor.capture());
        Assertions.assertEquals((Object)"Error disconnecting from Datadog.", (Object)((LoggingEvent)this.logCaptor.getValue()).getRenderedMessage());
        Assertions.assertEquals((Object)Level.WARN, (Object)((LoggingEvent)this.logCaptor.getValue()).getLevel());
    }

    @Test
    public void prefixShouldPrepend() {
        DatadogReporter reporter = new DatadogReporter(this.registry, this.client, "foo", Option.empty(), Option.empty(), MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"foo.bar", (Object)reporter.prefix(new String[]{"bar"}));
    }

    @Test
    public void payloadBuilderShouldBuildExpectedPayloadString() {
        String payload = new DatadogReporter.PayloadBuilder().withMetricType(DatadogReporter.MetricType.gauge).addGauge("foo", 0L, 0L).addGauge("bar", 1L, 999L).withHost("xhost").withTags(Arrays.asList("tag1", "tag2")).build();
        Assertions.assertEquals((Object)"{\"series\":[{\"metric\":\"foo\",\"points\":[[0,0]],\"host\":\"xhost\",\"tags\":[\"tag1\",\"tag2\"]},{\"metric\":\"bar\",\"points\":[[1,999]],\"host\":\"xhost\",\"tags\":[\"tag1\",\"tag2\"]}]}", (Object)payload);
    }
}

