/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.heartbeat;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.heartbeat.HeartbeatUtils;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieHeartbeatClient
extends HoodieCommonTestHarness {
    private static String instantTime1 = "100";
    private static String instantTime2 = "101";
    private static Long heartBeatInterval = 1000L;
    private static int numTolerableMisses = 1;

    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testStartHeartbeat() throws IOException {
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient((FileSystem)this.metaClient.getFs(), this.metaClient.getBasePath(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start(instantTime1);
        FileStatus[] fs = this.metaClient.getFs().listStatus(new Path(hoodieHeartbeatClient.getHeartbeatFolderPath()));
        Assertions.assertTrue((fs.length == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)fs[0].getPath().toString().contains(instantTime1));
    }

    @Test
    public void testStopHeartbeat() {
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient((FileSystem)this.metaClient.getFs(), this.metaClient.getBasePath(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start(instantTime1);
        hoodieHeartbeatClient.stop(instantTime1);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> hoodieHeartbeatClient.getHeartbeat(instantTime1).getNumHeartbeats() > 0);
        Integer numHeartBeats = hoodieHeartbeatClient.getHeartbeat(instantTime1).getNumHeartbeats();
        Assertions.assertTrue((numHeartBeats == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testIsHeartbeatExpired() throws IOException {
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient((FileSystem)this.metaClient.getFs(), this.metaClient.getBasePath(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start(instantTime1);
        hoodieHeartbeatClient.stop(instantTime1);
        Assertions.assertFalse((boolean)hoodieHeartbeatClient.isHeartbeatExpired(instantTime1));
    }

    @Test
    public void testNumHeartbeatsGenerated() {
        Long heartBeatInterval = 5000L;
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient((FileSystem)this.metaClient.getFs(), this.metaClient.getBasePath(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start("100");
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> hoodieHeartbeatClient.getHeartbeat(instantTime1).getNumHeartbeats() >= 1);
    }

    @Test
    public void testDeleteWrongHeartbeat() throws IOException {
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient((FileSystem)this.metaClient.getFs(), this.metaClient.getBasePath(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start(instantTime1);
        hoodieHeartbeatClient.stop(instantTime1);
        Assertions.assertFalse((boolean)HeartbeatUtils.deleteHeartbeatFile((FileSystem)this.metaClient.getFs(), (String)this.basePath, (String)instantTime2));
    }

    @Test
    public void testStopHeartbeatTimers() throws IOException {
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient((FileSystem)this.metaClient.getFs(), this.metaClient.getBasePath(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start(instantTime1);
        hoodieHeartbeatClient.stopHeartbeatTimers();
        Assertions.assertFalse((boolean)hoodieHeartbeatClient.isHeartbeatExpired(instantTime1));
        Assertions.assertTrue((boolean)hoodieHeartbeatClient.getHeartbeat(instantTime1).isHeartbeatStopped());
    }
}

