/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieAvroOrcWriter;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieOrcConfig;
import org.apache.hudi.io.storage.TestHoodieReaderWriterBase;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

public class TestHoodieOrcReaderWriter
extends TestHoodieReaderWriterBase {
    @Override
    protected Path getFilePath() {
        return new Path(this.tempDir.toString() + "/f1_1-0-1_000.orc");
    }

    protected HoodieAvroOrcWriter createWriter(Schema avroSchema, boolean populateMetaFields) throws Exception {
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-5, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        Configuration conf = new Configuration();
        int orcStripSize = Integer.parseInt((String)HoodieStorageConfig.ORC_STRIPE_SIZE.defaultValue());
        int orcBlockSize = Integer.parseInt((String)HoodieStorageConfig.ORC_BLOCK_SIZE.defaultValue());
        int maxFileSize = Integer.parseInt((String)HoodieStorageConfig.ORC_FILE_MAX_SIZE.defaultValue());
        HoodieOrcConfig config = new HoodieOrcConfig(conf, CompressionKind.ZLIB, orcStripSize, orcBlockSize, (long)maxFileSize, filter);
        TaskContextSupplier mockTaskContextSupplier = (TaskContextSupplier)Mockito.mock(TaskContextSupplier.class);
        Supplier partitionSupplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)mockTaskContextSupplier.getPartitionIdSupplier()).thenReturn((Object)partitionSupplier);
        Mockito.when(partitionSupplier.get()).thenReturn((Object)10);
        String instantTime = "000";
        return new HoodieAvroOrcWriter(instantTime, this.getFilePath(), config, avroSchema, mockTaskContextSupplier);
    }

    @Override
    protected HoodieAvroFileReader createReader(Configuration conf) throws Exception {
        return (HoodieAvroFileReader)HoodieFileReaderFactory.getReaderFactory((HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO).getFileReader(conf, this.getFilePath());
    }

    @Override
    protected void verifyMetadata(Configuration conf) throws IOException {
        Reader orcReader = OrcFile.createReader((Path)this.getFilePath(), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
        Assertions.assertEquals((int)4, (int)orcReader.getMetadataKeys().size());
        Assertions.assertTrue((boolean)orcReader.getMetadataKeys().contains("hoodie_min_record_key"));
        Assertions.assertTrue((boolean)orcReader.getMetadataKeys().contains("hoodie_max_record_key"));
        Assertions.assertTrue((boolean)orcReader.getMetadataKeys().contains("org.apache.hudi.bloomfilter"));
        Assertions.assertTrue((boolean)orcReader.getMetadataKeys().contains("orc.avro.schema"));
        Assertions.assertEquals((Object)CompressionKind.ZLIB.name(), (Object)orcReader.getCompressionKind().toString());
        Assertions.assertEquals((long)50L, (long)orcReader.getNumberOfRows());
    }

    @Override
    protected void verifySchema(Configuration conf, String schemaPath) throws IOException {
        Reader orcReader = OrcFile.createReader((Path)this.getFilePath(), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
        if ("/exampleSchema.avsc".equals(schemaPath)) {
            Assertions.assertEquals((Object)"struct<_row_key:string,time:string,number:int>", (Object)orcReader.getSchema().toString());
        } else if ("/exampleSchemaWithUDT.avsc".equals(schemaPath)) {
            Assertions.assertEquals((Object)"struct<_row_key:string,time:string,number:int,driver:struct<driver_name:string,list:array<int>,map:map<string,string>>>", (Object)orcReader.getSchema().toString());
        }
    }
}

