/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.Gauge;
import java.util.UUID;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestHoodieConsoleMetrics {
    @Mock
    HoodieWriteConfig config;
    HoodieMetrics hoodieMetrics;
    Metrics metrics;

    @BeforeEach
    public void start() {
        Mockito.when((Object)this.config.getTableName()).thenReturn((Object)"console_metrics_test");
        Mockito.when((Object)this.config.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.CONSOLE);
        Mockito.when((Object)this.config.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
        this.hoodieMetrics = new HoodieMetrics(this.config);
        this.metrics = this.hoodieMetrics.getMetrics();
    }

    @AfterEach
    public void stop() {
        this.metrics.shutdown();
    }

    @Test
    public void testRegisterGauge() {
        this.metrics.registerGauge("metric1", 123L);
        Assertions.assertEquals((Object)"123", (Object)((Gauge)this.metrics.getRegistry().getGauges().get("metric1")).getValue().toString());
    }
}

